<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for patterns StructType
 * @subpackage Structs
 */
class Patterns extends XCommonMembersExtension
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XPatternMember[]
     */
    public $pattern;
    /**
     * Constructor method for patterns
     * @uses Patterns::setPattern()
     * @param \StructType\XPatternMember[] $pattern
     */
    public function __construct(array $pattern = array())
    {
        $this
            ->setPattern($pattern);
    }
    /**
     * Get pattern value
     * @return \StructType\XPatternMember[]|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @throws \InvalidArgumentException
     * @param \StructType\XPatternMember[] $pattern
     * @return \StructType\Patterns
     */
    public function setPattern(array $pattern = array())
    {
        foreach ($pattern as $patternsPatternItem) {
            // validation for constraint: itemType
            if (!$patternsPatternItem instanceof \StructType\XPatternMember) {
                throw new \InvalidArgumentException(sprintf('The pattern property can only contain items of \StructType\XPatternMember, "%s" given', is_object($patternsPatternItem) ? get_class($patternsPatternItem) : gettype($patternsPatternItem)), __LINE__);
            }
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Add item to pattern value
     * @throws \InvalidArgumentException
     * @param \StructType\XPatternMember $item
     * @return \StructType\Patterns
     */
    public function addToPattern(\StructType\XPatternMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XPatternMember) {
            throw new \InvalidArgumentException(sprintf('The pattern property can only contain items of \StructType\XPatternMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pattern[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Patterns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
