<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for passwordCredentials StructType
 * Meta informations extracted from the WSDL
 * - documentation: Not Applicable for Add. Credential configuration for password. | Not Applicable for Add. Credential configuration for password. | Not Applicable for Add. Credential configuration for password | Not Applicable for Add. Credential
 * configuration for password | Not Applicable for Add. Credential configuration for password. | Not Applicable for Add. Credential configuration for password
 * @subpackage Structs
 */
class PasswordCredentials extends AbstractStructBase
{
    /**
     * The pwdCredPolicyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $pwdCredPolicyName;
    /**
     * The pwdCredUserCantChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdCredUserCantChange;
    /**
     * The pwdCredUserMustChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdCredUserMustChange;
    /**
     * The pwdCredDoesNotExpire
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdCredDoesNotExpire;
    /**
     * The pwdCredTimeChanged
     * Meta informations extracted from the WSDL
     * - documentation: Read Only | Read Only | Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pwdCredTimeChanged;
    /**
     * The pwdCredTimeAdminLockout
     * Meta informations extracted from the WSDL
     * - documentation: Read Only | Read Only | Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pwdCredTimeAdminLockout;
    /**
     * The pwdCredLockedByAdministrator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdCredLockedByAdministrator;
    /**
     * The pwdResetHackCount
     * Meta informations extracted from the WSDL
     * - documentation: The tag will be ignored in add, while update you can reset the hack count. | The tag will be ignored in add, while update you can reset the hack count. | The tag will be ignored in add, while update you can reset the hack count. |
     * The tag will be ignored in add, while update you can reset the hack count. | The tag will be ignored in add, while update you can reset the hack count. | The tag will be ignored in add, while update you can reset the hack count.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdResetHackCount;
    /**
     * Constructor method for passwordCredentials
     * @uses PasswordCredentials::setPwdCredPolicyName()
     * @uses PasswordCredentials::setPwdCredUserCantChange()
     * @uses PasswordCredentials::setPwdCredUserMustChange()
     * @uses PasswordCredentials::setPwdCredDoesNotExpire()
     * @uses PasswordCredentials::setPwdCredTimeChanged()
     * @uses PasswordCredentials::setPwdCredTimeAdminLockout()
     * @uses PasswordCredentials::setPwdCredLockedByAdministrator()
     * @uses PasswordCredentials::setPwdResetHackCount()
     * @param \StructType\XFkType $pwdCredPolicyName
     * @param string $pwdCredUserCantChange
     * @param string $pwdCredUserMustChange
     * @param string $pwdCredDoesNotExpire
     * @param string $pwdCredTimeChanged
     * @param string $pwdCredTimeAdminLockout
     * @param string $pwdCredLockedByAdministrator
     * @param string $pwdResetHackCount
     */
    public function __construct(\StructType\XFkType $pwdCredPolicyName = null, $pwdCredUserCantChange = null, $pwdCredUserMustChange = null, $pwdCredDoesNotExpire = null, $pwdCredTimeChanged = null, $pwdCredTimeAdminLockout = null, $pwdCredLockedByAdministrator = null, $pwdResetHackCount = null)
    {
        $this
            ->setPwdCredPolicyName($pwdCredPolicyName)
            ->setPwdCredUserCantChange($pwdCredUserCantChange)
            ->setPwdCredUserMustChange($pwdCredUserMustChange)
            ->setPwdCredDoesNotExpire($pwdCredDoesNotExpire)
            ->setPwdCredTimeChanged($pwdCredTimeChanged)
            ->setPwdCredTimeAdminLockout($pwdCredTimeAdminLockout)
            ->setPwdCredLockedByAdministrator($pwdCredLockedByAdministrator)
            ->setPwdResetHackCount($pwdResetHackCount);
    }
    /**
     * Get pwdCredPolicyName value
     * @return \StructType\XFkType|null
     */
    public function getPwdCredPolicyName()
    {
        return $this->pwdCredPolicyName;
    }
    /**
     * Set pwdCredPolicyName value
     * @param \StructType\XFkType $pwdCredPolicyName
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredPolicyName(\StructType\XFkType $pwdCredPolicyName = null)
    {
        $this->pwdCredPolicyName = $pwdCredPolicyName;
        return $this;
    }
    /**
     * Get pwdCredUserCantChange value
     * @return string|null
     */
    public function getPwdCredUserCantChange()
    {
        return $this->pwdCredUserCantChange;
    }
    /**
     * Set pwdCredUserCantChange value
     * @param string $pwdCredUserCantChange
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredUserCantChange($pwdCredUserCantChange = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pwdCredUserCantChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdCredUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pwdCredUserCantChange, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pwdCredUserCantChange) && !is_string($pwdCredUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pwdCredUserCantChange)), __LINE__);
        }
        $this->pwdCredUserCantChange = $pwdCredUserCantChange;
        return $this;
    }
    /**
     * Get pwdCredUserMustChange value
     * @return string|null
     */
    public function getPwdCredUserMustChange()
    {
        return $this->pwdCredUserMustChange;
    }
    /**
     * Set pwdCredUserMustChange value
     * @param string $pwdCredUserMustChange
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredUserMustChange($pwdCredUserMustChange = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pwdCredUserMustChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdCredUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pwdCredUserMustChange, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pwdCredUserMustChange) && !is_string($pwdCredUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pwdCredUserMustChange)), __LINE__);
        }
        $this->pwdCredUserMustChange = $pwdCredUserMustChange;
        return $this;
    }
    /**
     * Get pwdCredDoesNotExpire value
     * @return string|null
     */
    public function getPwdCredDoesNotExpire()
    {
        return $this->pwdCredDoesNotExpire;
    }
    /**
     * Set pwdCredDoesNotExpire value
     * @param string $pwdCredDoesNotExpire
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredDoesNotExpire($pwdCredDoesNotExpire = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pwdCredDoesNotExpire) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdCredDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pwdCredDoesNotExpire, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pwdCredDoesNotExpire) && !is_string($pwdCredDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pwdCredDoesNotExpire)), __LINE__);
        }
        $this->pwdCredDoesNotExpire = $pwdCredDoesNotExpire;
        return $this;
    }
    /**
     * Get pwdCredTimeChanged value
     * @return string|null
     */
    public function getPwdCredTimeChanged()
    {
        return $this->pwdCredTimeChanged;
    }
    /**
     * Set pwdCredTimeChanged value
     * @param string $pwdCredTimeChanged
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredTimeChanged($pwdCredTimeChanged = null)
    {
        // validation for constraint: string
        if (!is_null($pwdCredTimeChanged) && !is_string($pwdCredTimeChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pwdCredTimeChanged)), __LINE__);
        }
        $this->pwdCredTimeChanged = $pwdCredTimeChanged;
        return $this;
    }
    /**
     * Get pwdCredTimeAdminLockout value
     * @return string|null
     */
    public function getPwdCredTimeAdminLockout()
    {
        return $this->pwdCredTimeAdminLockout;
    }
    /**
     * Set pwdCredTimeAdminLockout value
     * @param string $pwdCredTimeAdminLockout
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredTimeAdminLockout($pwdCredTimeAdminLockout = null)
    {
        // validation for constraint: string
        if (!is_null($pwdCredTimeAdminLockout) && !is_string($pwdCredTimeAdminLockout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pwdCredTimeAdminLockout)), __LINE__);
        }
        $this->pwdCredTimeAdminLockout = $pwdCredTimeAdminLockout;
        return $this;
    }
    /**
     * Get pwdCredLockedByAdministrator value
     * @return string|null
     */
    public function getPwdCredLockedByAdministrator()
    {
        return $this->pwdCredLockedByAdministrator;
    }
    /**
     * Set pwdCredLockedByAdministrator value
     * @param string $pwdCredLockedByAdministrator
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredLockedByAdministrator($pwdCredLockedByAdministrator = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pwdCredLockedByAdministrator) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdCredLockedByAdministrator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pwdCredLockedByAdministrator, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pwdCredLockedByAdministrator) && !is_string($pwdCredLockedByAdministrator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pwdCredLockedByAdministrator)), __LINE__);
        }
        $this->pwdCredLockedByAdministrator = $pwdCredLockedByAdministrator;
        return $this;
    }
    /**
     * Get pwdResetHackCount value
     * @return string|null
     */
    public function getPwdResetHackCount()
    {
        return $this->pwdResetHackCount;
    }
    /**
     * Set pwdResetHackCount value
     * @param string $pwdResetHackCount
     * @return \StructType\PasswordCredentials
     */
    public function setPwdResetHackCount($pwdResetHackCount = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pwdResetHackCount) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdResetHackCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pwdResetHackCount, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pwdResetHackCount) && !is_string($pwdResetHackCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pwdResetHackCount)), __LINE__);
        }
        $this->pwdResetHackCount = $pwdResetHackCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PasswordCredentials
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
