<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXPhone StructType
 * @subpackage Structs
 */
class OXPhone extends AbstractStructBase
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkTypeProduct
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $commonDeviceConfigName;
    /**
     * The commonPhoneConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $commonPhoneConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $aarNeighborhoodName;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkTypeProduct_Protocol
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta informations extracted from the WSDL
     * - documentation: This Tag is valid only for SIP Phones and SIP Trunks
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $geoLocationFilterName;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Lines
     */
    public $lines;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $phoneTemplateName;
    /**
     * The primaryPhoneName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $primaryPhoneName;
    /**
     * The ringSettingIdleBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $ringSettingIdleBlfAudibleAlert;
    /**
     * The ringSettingBusyBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $ringSettingBusyBlfAudibleAlert;
    /**
     * The blfDirectedCallParks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkTypeProduct
     */
    public $networkLocale;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Services
     */
    public $services;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $softkeyTemplateName;
    /**
     * The defaultProfileName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkTypeProduct_Protocol
     */
    public $defaultProfileName;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $joinAcrossLines;
    /**
     * The builtInBridgeStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $builtInBridgeStatus;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callInfoPrivacyStatus;
    /**
     * The ownerUserName
     * Meta informations extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkTypeProduct
     */
    public $ownerUserName;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $packetCaptureMode;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - documentation: Support for this tag has been removed for IMS phones from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $presenceGroupName;
    /**
     * The certificateOperation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - documentation: authenticationMode can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - documentation: keySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $keySize;
    /**
     * The keyOrder
     * Meta informations extracted from the WSDL
     * - documentation: keyOrder can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $keyOrder;
    /**
     * The ecKeySize
     * Meta informations extracted from the WSDL
     * - documentation: ecKeySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $ecKeySize;
    /**
     * The deviceMobilityMode
     * Meta informations extracted from the WSDL
     * - documentation: Specifies if the phone is configured for device mobility or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $deviceMobilityMode;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkTypeProduct_Protocol
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $dndRingSetting;
    /**
     * The mobilityUserIdName
     * Meta informations extracted from the WSDL
     * - documentation: The userid of the mobility user for this phone.Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $mobilityUserIdName;
    /**
     * The phoneSuite
     * Meta informations extracted from the WSDL
     * - documentation: If a blank tag is passed ,the value of the default is inserted into the database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $phoneSuite;
    /**
     * The phoneServiceDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $phoneServiceDisplay;
    /**
     * The mtpPreferedCodec
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $mtpPreferedCodec;
    /**
     * The dialRulesName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkTypeProduct
     */
    public $dialRulesName;
    /**
     * The outboundCallRollover
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that Automatic Outbound Callrollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $outboundCallRollover;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $featureControlPolicy;
    /**
     * The deviceTrustMode
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for TIP endpoints
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $deviceTrustMode;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The cgpnIngressDN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $cgpnIngressDN;
    /**
     * The wifiHotspotProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $wifiHotspotProfile;
    /**
     * The wirelessLanProfileGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * The elinGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $elinGroup;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXPhone
     * @uses OXPhone::setProduct()
     * @uses OXPhone::setClass()
     * @uses OXPhone::setProtocol()
     * @uses OXPhone::setProtocolSide()
     * @uses OXPhone::setCallingSearchSpaceName()
     * @uses OXPhone::setDevicePoolName()
     * @uses OXPhone::setCommonDeviceConfigName()
     * @uses OXPhone::setCommonPhoneConfigName()
     * @uses OXPhone::setNetworkLocation()
     * @uses OXPhone::setLocationName()
     * @uses OXPhone::setMediaResourceListName()
     * @uses OXPhone::setNetworkHoldMohAudioSourceId()
     * @uses OXPhone::setUserHoldMohAudioSourceId()
     * @uses OXPhone::setAutomatedAlternateRoutingCssName()
     * @uses OXPhone::setAarNeighborhoodName()
     * @uses OXPhone::setMlppIndicationStatus()
     * @uses OXPhone::setPreemption()
     * @uses OXPhone::setUseTrustedRelayPoint()
     * @uses OXPhone::setSecurityProfileName()
     * @uses OXPhone::setSipProfileName()
     * @uses OXPhone::setCgpnTransformationCssName()
     * @uses OXPhone::setGeoLocationName()
     * @uses OXPhone::setGeoLocationFilterName()
     * @uses OXPhone::setLines()
     * @uses OXPhone::setPhoneTemplateName()
     * @uses OXPhone::setPrimaryPhoneName()
     * @uses OXPhone::setRingSettingIdleBlfAudibleAlert()
     * @uses OXPhone::setRingSettingBusyBlfAudibleAlert()
     * @uses OXPhone::setBlfDirectedCallParks()
     * @uses OXPhone::setAddOnModules()
     * @uses OXPhone::setUserLocale()
     * @uses OXPhone::setNetworkLocale()
     * @uses OXPhone::setServices()
     * @uses OXPhone::setSoftkeyTemplateName()
     * @uses OXPhone::setDefaultProfileName()
     * @uses OXPhone::setSingleButtonBarge()
     * @uses OXPhone::setJoinAcrossLines()
     * @uses OXPhone::setBuiltInBridgeStatus()
     * @uses OXPhone::setCallInfoPrivacyStatus()
     * @uses OXPhone::setOwnerUserName()
     * @uses OXPhone::setPacketCaptureMode()
     * @uses OXPhone::setSubscribeCallingSearchSpaceName()
     * @uses OXPhone::setRerouteCallingSearchSpaceName()
     * @uses OXPhone::setPresenceGroupName()
     * @uses OXPhone::setCertificateOperation()
     * @uses OXPhone::setAuthenticationMode()
     * @uses OXPhone::setKeySize()
     * @uses OXPhone::setKeyOrder()
     * @uses OXPhone::setEcKeySize()
     * @uses OXPhone::setDeviceMobilityMode()
     * @uses OXPhone::setDndOption()
     * @uses OXPhone::setDndRingSetting()
     * @uses OXPhone::setMobilityUserIdName()
     * @uses OXPhone::setPhoneSuite()
     * @uses OXPhone::setPhoneServiceDisplay()
     * @uses OXPhone::setMtpPreferedCodec()
     * @uses OXPhone::setDialRulesName()
     * @uses OXPhone::setOutboundCallRollover()
     * @uses OXPhone::setAlwaysUsePrimeLine()
     * @uses OXPhone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses OXPhone::setFeatureControlPolicy()
     * @uses OXPhone::setDeviceTrustMode()
     * @uses OXPhone::setConfidentialAccess()
     * @uses OXPhone::setCgpnIngressDN()
     * @uses OXPhone::setWifiHotspotProfile()
     * @uses OXPhone::setWirelessLanProfileGroup()
     * @uses OXPhone::setElinGroup()
     * @uses OXPhone::setCtiid()
     * @uses OXPhone::setUuid()
     * @param \StructType\OXFkType $product
     * @param \StructType\OXFkType $class
     * @param \StructType\OXFkTypeProduct $protocol
     * @param \StructType\OXFkType $protocolSide
     * @param \StructType\OXFkType $callingSearchSpaceName
     * @param \StructType\OXFkType $devicePoolName
     * @param \StructType\OXFkType $commonDeviceConfigName
     * @param \StructType\OXFkType $commonPhoneConfigName
     * @param \StructType\OXFkType $networkLocation
     * @param \StructType\OXFkType $locationName
     * @param \StructType\OXFkType $mediaResourceListName
     * @param \StructType\OXFkType $networkHoldMohAudioSourceId
     * @param \StructType\OXFkType $userHoldMohAudioSourceId
     * @param \StructType\OXFkType $automatedAlternateRoutingCssName
     * @param \StructType\OXFkType $aarNeighborhoodName
     * @param \StructType\OXFkType $mlppIndicationStatus
     * @param \StructType\OXFkType $preemption
     * @param \StructType\OXFkType $useTrustedRelayPoint
     * @param \StructType\OXFkTypeProduct_Protocol $securityProfileName
     * @param \StructType\OXFkType $sipProfileName
     * @param \StructType\OXFkType $cgpnTransformationCssName
     * @param \StructType\OXFkType $geoLocationName
     * @param \StructType\OXFkType $geoLocationFilterName
     * @param \StructType\Lines $lines
     * @param \StructType\OXFkType $phoneTemplateName
     * @param \StructType\OXFkType $primaryPhoneName
     * @param \StructType\OXFkType $ringSettingIdleBlfAudibleAlert
     * @param \StructType\OXFkType $ringSettingBusyBlfAudibleAlert
     * @param \StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @param \StructType\AddOnModules $addOnModules
     * @param \StructType\OXFkType $userLocale
     * @param \StructType\OXFkTypeProduct $networkLocale
     * @param \StructType\Services $services
     * @param \StructType\OXFkType $softkeyTemplateName
     * @param \StructType\OXFkTypeProduct_Protocol $defaultProfileName
     * @param \StructType\OXFkType $singleButtonBarge
     * @param \StructType\OXFkType $joinAcrossLines
     * @param \StructType\OXFkType $builtInBridgeStatus
     * @param \StructType\OXFkType $callInfoPrivacyStatus
     * @param \StructType\OXFkTypeProduct $ownerUserName
     * @param \StructType\OXFkType $packetCaptureMode
     * @param \StructType\OXFkType $subscribeCallingSearchSpaceName
     * @param \StructType\OXFkType $rerouteCallingSearchSpaceName
     * @param \StructType\OXFkType $presenceGroupName
     * @param \StructType\OXFkType $certificateOperation
     * @param \StructType\OXFkType $authenticationMode
     * @param \StructType\OXFkType $keySize
     * @param \StructType\OXFkType $keyOrder
     * @param \StructType\OXFkType $ecKeySize
     * @param \StructType\OXFkType $deviceMobilityMode
     * @param \StructType\OXFkTypeProduct_Protocol $dndOption
     * @param \StructType\OXFkType $dndRingSetting
     * @param \StructType\OXFkType $mobilityUserIdName
     * @param \StructType\OXFkType $phoneSuite
     * @param \StructType\OXFkType $phoneServiceDisplay
     * @param \StructType\OXFkType $mtpPreferedCodec
     * @param \StructType\OXFkTypeProduct $dialRulesName
     * @param \StructType\OXFkType $outboundCallRollover
     * @param \StructType\OXFkType $alwaysUsePrimeLine
     * @param \StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @param \StructType\OXFkType $featureControlPolicy
     * @param \StructType\OXFkType $deviceTrustMode
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param \StructType\OXFkType $cgpnIngressDN
     * @param \StructType\OXFkType $wifiHotspotProfile
     * @param \StructType\OXFkType $wirelessLanProfileGroup
     * @param \StructType\OXFkType $elinGroup
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(\StructType\OXFkType $product = null, \StructType\OXFkType $class = null, \StructType\OXFkTypeProduct $protocol = null, \StructType\OXFkType $protocolSide = null, \StructType\OXFkType $callingSearchSpaceName = null, \StructType\OXFkType $devicePoolName = null, \StructType\OXFkType $commonDeviceConfigName = null, \StructType\OXFkType $commonPhoneConfigName = null, \StructType\OXFkType $networkLocation = null, \StructType\OXFkType $locationName = null, \StructType\OXFkType $mediaResourceListName = null, \StructType\OXFkType $networkHoldMohAudioSourceId = null, \StructType\OXFkType $userHoldMohAudioSourceId = null, \StructType\OXFkType $automatedAlternateRoutingCssName = null, \StructType\OXFkType $aarNeighborhoodName = null, \StructType\OXFkType $mlppIndicationStatus = null, \StructType\OXFkType $preemption = null, \StructType\OXFkType $useTrustedRelayPoint = null, \StructType\OXFkTypeProduct_Protocol $securityProfileName = null, \StructType\OXFkType $sipProfileName = null, \StructType\OXFkType $cgpnTransformationCssName = null, \StructType\OXFkType $geoLocationName = null, \StructType\OXFkType $geoLocationFilterName = null, \StructType\Lines $lines = null, \StructType\OXFkType $phoneTemplateName = null, \StructType\OXFkType $primaryPhoneName = null, \StructType\OXFkType $ringSettingIdleBlfAudibleAlert = null, \StructType\OXFkType $ringSettingBusyBlfAudibleAlert = null, \StructType\BlfDirectedCallParks $blfDirectedCallParks = null, \StructType\AddOnModules $addOnModules = null, \StructType\OXFkType $userLocale = null, \StructType\OXFkTypeProduct $networkLocale = null, \StructType\Services $services = null, \StructType\OXFkType $softkeyTemplateName = null, \StructType\OXFkTypeProduct_Protocol $defaultProfileName = null, \StructType\OXFkType $singleButtonBarge = null, \StructType\OXFkType $joinAcrossLines = null, \StructType\OXFkType $builtInBridgeStatus = null, \StructType\OXFkType $callInfoPrivacyStatus = null, \StructType\OXFkTypeProduct $ownerUserName = null, \StructType\OXFkType $packetCaptureMode = null, \StructType\OXFkType $subscribeCallingSearchSpaceName = null, \StructType\OXFkType $rerouteCallingSearchSpaceName = null, \StructType\OXFkType $presenceGroupName = null, \StructType\OXFkType $certificateOperation = null, \StructType\OXFkType $authenticationMode = null, \StructType\OXFkType $keySize = null, \StructType\OXFkType $keyOrder = null, \StructType\OXFkType $ecKeySize = null, \StructType\OXFkType $deviceMobilityMode = null, \StructType\OXFkTypeProduct_Protocol $dndOption = null, \StructType\OXFkType $dndRingSetting = null, \StructType\OXFkType $mobilityUserIdName = null, \StructType\OXFkType $phoneSuite = null, \StructType\OXFkType $phoneServiceDisplay = null, \StructType\OXFkType $mtpPreferedCodec = null, \StructType\OXFkTypeProduct $dialRulesName = null, \StructType\OXFkType $outboundCallRollover = null, \StructType\OXFkType $alwaysUsePrimeLine = null, \StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage = null, \StructType\OXFkType $featureControlPolicy = null, \StructType\OXFkType $deviceTrustMode = null, \StructType\ConfidentialAccess $confidentialAccess = null, \StructType\OXFkType $cgpnIngressDN = null, \StructType\OXFkType $wifiHotspotProfile = null, \StructType\OXFkType $wirelessLanProfileGroup = null, \StructType\OXFkType $elinGroup = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setLines($lines)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert)
            ->setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setServices($services)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setDefaultProfileName($defaultProfileName)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setBuiltInBridgeStatus($builtInBridgeStatus)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setOwnerUserName($ownerUserName)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setPresenceGroupName($presenceGroupName)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setKeyOrder($keyOrder)
            ->setEcKeySize($ecKeySize)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setMobilityUserIdName($mobilityUserIdName)
            ->setPhoneSuite($phoneSuite)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setMtpPreferedCodec($mtpPreferedCodec)
            ->setDialRulesName($dialRulesName)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setDeviceTrustMode($deviceTrustMode)
            ->setConfidentialAccess($confidentialAccess)
            ->setCgpnIngressDN($cgpnIngressDN)
            ->setWifiHotspotProfile($wifiHotspotProfile)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup)
            ->setElinGroup($elinGroup)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get product value
     * @return \StructType\OXFkType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\OXFkType $product
     * @return \StructType\OXPhone
     */
    public function setProduct(\StructType\OXFkType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\OXFkType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\OXFkType $class
     * @return \StructType\OXPhone
     */
    public function setClass(\StructType\OXFkType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return \StructType\OXFkTypeProduct|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param \StructType\OXFkTypeProduct $protocol
     * @return \StructType\OXPhone
     */
    public function setProtocol(\StructType\OXFkTypeProduct $protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return \StructType\OXFkType|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param \StructType\OXFkType $protocolSide
     * @return \StructType\OXPhone
     */
    public function setProtocolSide(\StructType\OXFkType $protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\OXFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\OXFkType $callingSearchSpaceName
     * @return \StructType\OXPhone
     */
    public function setCallingSearchSpaceName(\StructType\OXFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\OXFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\OXFkType $devicePoolName
     * @return \StructType\OXPhone
     */
    public function setDevicePoolName(\StructType\OXFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \StructType\OXFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \StructType\OXFkType $commonDeviceConfigName
     * @return \StructType\OXPhone
     */
    public function setCommonDeviceConfigName(\StructType\OXFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return \StructType\OXFkType|null
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param \StructType\OXFkType $commonPhoneConfigName
     * @return \StructType\OXPhone
     */
    public function setCommonPhoneConfigName(\StructType\OXFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return \StructType\OXFkType|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param \StructType\OXFkType $networkLocation
     * @return \StructType\OXPhone
     */
    public function setNetworkLocation(\StructType\OXFkType $networkLocation = null)
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\OXFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\OXFkType $locationName
     * @return \StructType\OXPhone
     */
    public function setLocationName(\StructType\OXFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \StructType\OXFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \StructType\OXFkType $mediaResourceListName
     * @return \StructType\OXPhone
     */
    public function setMediaResourceListName(\StructType\OXFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return \StructType\OXFkType|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param \StructType\OXFkType $networkHoldMohAudioSourceId
     * @return \StructType\OXPhone
     */
    public function setNetworkHoldMohAudioSourceId(\StructType\OXFkType $networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return \StructType\OXFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param \StructType\OXFkType $userHoldMohAudioSourceId
     * @return \StructType\OXPhone
     */
    public function setUserHoldMohAudioSourceId(\StructType\OXFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \StructType\OXFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \StructType\OXFkType $automatedAlternateRoutingCssName
     * @return \StructType\OXPhone
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\OXFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\OXFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\OXFkType $aarNeighborhoodName
     * @return \StructType\OXPhone
     */
    public function setAarNeighborhoodName(\StructType\OXFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return \StructType\OXFkType|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param \StructType\OXFkType $mlppIndicationStatus
     * @return \StructType\OXPhone
     */
    public function setMlppIndicationStatus(\StructType\OXFkType $mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return \StructType\OXFkType|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param \StructType\OXFkType $preemption
     * @return \StructType\OXPhone
     */
    public function setPreemption(\StructType\OXFkType $preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return \StructType\OXFkType|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param \StructType\OXFkType $useTrustedRelayPoint
     * @return \StructType\OXPhone
     */
    public function setUseTrustedRelayPoint(\StructType\OXFkType $useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \StructType\OXFkTypeProduct_Protocol|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \StructType\OXFkTypeProduct_Protocol $securityProfileName
     * @return \StructType\OXPhone
     */
    public function setSecurityProfileName(\StructType\OXFkTypeProduct_Protocol $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return \StructType\OXFkType|null
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param \StructType\OXFkType $sipProfileName
     * @return \StructType\OXPhone
     */
    public function setSipProfileName(\StructType\OXFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \StructType\OXFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \StructType\OXFkType $cgpnTransformationCssName
     * @return \StructType\OXPhone
     */
    public function setCgpnTransformationCssName(\StructType\OXFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \StructType\OXFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \StructType\OXFkType $geoLocationName
     * @return \StructType\OXPhone
     */
    public function setGeoLocationName(\StructType\OXFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \StructType\OXFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \StructType\OXFkType $geoLocationFilterName
     * @return \StructType\OXPhone
     */
    public function setGeoLocationFilterName(\StructType\OXFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get lines value
     * @return \StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \StructType\Lines $lines
     * @return \StructType\OXPhone
     */
    public function setLines(\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \StructType\OXFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \StructType\OXFkType $phoneTemplateName
     * @return \StructType\OXPhone
     */
    public function setPhoneTemplateName(\StructType\OXFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * @return \StructType\OXFkType|null
     */
    public function getPrimaryPhoneName()
    {
        return $this->primaryPhoneName;
    }
    /**
     * Set primaryPhoneName value
     * @param \StructType\OXFkType $primaryPhoneName
     * @return \StructType\OXPhone
     */
    public function setPrimaryPhoneName(\StructType\OXFkType $primaryPhoneName = null)
    {
        $this->primaryPhoneName = $primaryPhoneName;
        return $this;
    }
    /**
     * Get ringSettingIdleBlfAudibleAlert value
     * @return \StructType\OXFkType|null
     */
    public function getRingSettingIdleBlfAudibleAlert()
    {
        return $this->ringSettingIdleBlfAudibleAlert;
    }
    /**
     * Set ringSettingIdleBlfAudibleAlert value
     * @param \StructType\OXFkType $ringSettingIdleBlfAudibleAlert
     * @return \StructType\OXPhone
     */
    public function setRingSettingIdleBlfAudibleAlert(\StructType\OXFkType $ringSettingIdleBlfAudibleAlert = null)
    {
        $this->ringSettingIdleBlfAudibleAlert = $ringSettingIdleBlfAudibleAlert;
        return $this;
    }
    /**
     * Get ringSettingBusyBlfAudibleAlert value
     * @return \StructType\OXFkType|null
     */
    public function getRingSettingBusyBlfAudibleAlert()
    {
        return $this->ringSettingBusyBlfAudibleAlert;
    }
    /**
     * Set ringSettingBusyBlfAudibleAlert value
     * @param \StructType\OXFkType $ringSettingBusyBlfAudibleAlert
     * @return \StructType\OXPhone
     */
    public function setRingSettingBusyBlfAudibleAlert(\StructType\OXFkType $ringSettingBusyBlfAudibleAlert = null)
    {
        $this->ringSettingBusyBlfAudibleAlert = $ringSettingBusyBlfAudibleAlert;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return \StructType\BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param \StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @return \StructType\OXPhone
     */
    public function setBlfDirectedCallParks(\StructType\BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return \StructType\AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param \StructType\AddOnModules $addOnModules
     * @return \StructType\OXPhone
     */
    public function setAddOnModules(\StructType\AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return \StructType\OXFkType|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param \StructType\OXFkType $userLocale
     * @return \StructType\OXPhone
     */
    public function setUserLocale(\StructType\OXFkType $userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return \StructType\OXFkTypeProduct|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @param \StructType\OXFkTypeProduct $networkLocale
     * @return \StructType\OXPhone
     */
    public function setNetworkLocale(\StructType\OXFkTypeProduct $networkLocale = null)
    {
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get services value
     * @return \StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \StructType\Services $services
     * @return \StructType\OXPhone
     */
    public function setServices(\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \StructType\OXFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \StructType\OXFkType $softkeyTemplateName
     * @return \StructType\OXPhone
     */
    public function setSoftkeyTemplateName(\StructType\OXFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get defaultProfileName value
     * @return \StructType\OXFkTypeProduct_Protocol|null
     */
    public function getDefaultProfileName()
    {
        return $this->defaultProfileName;
    }
    /**
     * Set defaultProfileName value
     * @param \StructType\OXFkTypeProduct_Protocol $defaultProfileName
     * @return \StructType\OXPhone
     */
    public function setDefaultProfileName(\StructType\OXFkTypeProduct_Protocol $defaultProfileName = null)
    {
        $this->defaultProfileName = $defaultProfileName;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return \StructType\OXFkType|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param \StructType\OXFkType $singleButtonBarge
     * @return \StructType\OXPhone
     */
    public function setSingleButtonBarge(\StructType\OXFkType $singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return \StructType\OXFkType|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param \StructType\OXFkType $joinAcrossLines
     * @return \StructType\OXPhone
     */
    public function setJoinAcrossLines(\StructType\OXFkType $joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get builtInBridgeStatus value
     * @return \StructType\OXFkType|null
     */
    public function getBuiltInBridgeStatus()
    {
        return $this->builtInBridgeStatus;
    }
    /**
     * Set builtInBridgeStatus value
     * @param \StructType\OXFkType $builtInBridgeStatus
     * @return \StructType\OXPhone
     */
    public function setBuiltInBridgeStatus(\StructType\OXFkType $builtInBridgeStatus = null)
    {
        $this->builtInBridgeStatus = $builtInBridgeStatus;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return \StructType\OXFkType|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param \StructType\OXFkType $callInfoPrivacyStatus
     * @return \StructType\OXPhone
     */
    public function setCallInfoPrivacyStatus(\StructType\OXFkType $callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * @return \StructType\OXFkTypeProduct|null
     */
    public function getOwnerUserName()
    {
        return $this->ownerUserName;
    }
    /**
     * Set ownerUserName value
     * @param \StructType\OXFkTypeProduct $ownerUserName
     * @return \StructType\OXPhone
     */
    public function setOwnerUserName(\StructType\OXFkTypeProduct $ownerUserName = null)
    {
        $this->ownerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return \StructType\OXFkType|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param \StructType\OXFkType $packetCaptureMode
     * @return \StructType\OXPhone
     */
    public function setPacketCaptureMode(\StructType\OXFkType $packetCaptureMode = null)
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \StructType\OXFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \StructType\OXFkType $subscribeCallingSearchSpaceName
     * @return \StructType\OXPhone
     */
    public function setSubscribeCallingSearchSpaceName(\StructType\OXFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * @return \StructType\OXFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return $this->rerouteCallingSearchSpaceName;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * @param \StructType\OXFkType $rerouteCallingSearchSpaceName
     * @return \StructType\OXPhone
     */
    public function setRerouteCallingSearchSpaceName(\StructType\OXFkType $rerouteCallingSearchSpaceName = null)
    {
        $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\OXFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\OXFkType $presenceGroupName
     * @return \StructType\OXPhone
     */
    public function setPresenceGroupName(\StructType\OXFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return \StructType\OXFkType|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @param \StructType\OXFkType $certificateOperation
     * @return \StructType\OXPhone
     */
    public function setCertificateOperation(\StructType\OXFkType $certificateOperation = null)
    {
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return \StructType\OXFkType|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @param \StructType\OXFkType $authenticationMode
     * @return \StructType\OXPhone
     */
    public function setAuthenticationMode(\StructType\OXFkType $authenticationMode = null)
    {
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return \StructType\OXFkType|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @param \StructType\OXFkType $keySize
     * @return \StructType\OXPhone
     */
    public function setKeySize(\StructType\OXFkType $keySize = null)
    {
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get keyOrder value
     * @return \StructType\OXFkType|null
     */
    public function getKeyOrder()
    {
        return $this->keyOrder;
    }
    /**
     * Set keyOrder value
     * @param \StructType\OXFkType $keyOrder
     * @return \StructType\OXPhone
     */
    public function setKeyOrder(\StructType\OXFkType $keyOrder = null)
    {
        $this->keyOrder = $keyOrder;
        return $this;
    }
    /**
     * Get ecKeySize value
     * @return \StructType\OXFkType|null
     */
    public function getEcKeySize()
    {
        return $this->ecKeySize;
    }
    /**
     * Set ecKeySize value
     * @param \StructType\OXFkType $ecKeySize
     * @return \StructType\OXPhone
     */
    public function setEcKeySize(\StructType\OXFkType $ecKeySize = null)
    {
        $this->ecKeySize = $ecKeySize;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return \StructType\OXFkType|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @param \StructType\OXFkType $deviceMobilityMode
     * @return \StructType\OXPhone
     */
    public function setDeviceMobilityMode(\StructType\OXFkType $deviceMobilityMode = null)
    {
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get dndOption value
     * @return \StructType\OXFkTypeProduct_Protocol|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param \StructType\OXFkTypeProduct_Protocol $dndOption
     * @return \StructType\OXPhone
     */
    public function setDndOption(\StructType\OXFkTypeProduct_Protocol $dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return \StructType\OXFkType|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param \StructType\OXFkType $dndRingSetting
     * @return \StructType\OXPhone
     */
    public function setDndRingSetting(\StructType\OXFkType $dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get mobilityUserIdName value
     * @return \StructType\OXFkType|null
     */
    public function getMobilityUserIdName()
    {
        return $this->mobilityUserIdName;
    }
    /**
     * Set mobilityUserIdName value
     * @param \StructType\OXFkType $mobilityUserIdName
     * @return \StructType\OXPhone
     */
    public function setMobilityUserIdName(\StructType\OXFkType $mobilityUserIdName = null)
    {
        $this->mobilityUserIdName = $mobilityUserIdName;
        return $this;
    }
    /**
     * Get phoneSuite value
     * @return \StructType\OXFkType|null
     */
    public function getPhoneSuite()
    {
        return $this->phoneSuite;
    }
    /**
     * Set phoneSuite value
     * @param \StructType\OXFkType $phoneSuite
     * @return \StructType\OXPhone
     */
    public function setPhoneSuite(\StructType\OXFkType $phoneSuite = null)
    {
        $this->phoneSuite = $phoneSuite;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return \StructType\OXFkType|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @param \StructType\OXFkType $phoneServiceDisplay
     * @return \StructType\OXPhone
     */
    public function setPhoneServiceDisplay(\StructType\OXFkType $phoneServiceDisplay = null)
    {
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get mtpPreferedCodec value
     * @return \StructType\OXFkType|null
     */
    public function getMtpPreferedCodec()
    {
        return $this->mtpPreferedCodec;
    }
    /**
     * Set mtpPreferedCodec value
     * @param \StructType\OXFkType $mtpPreferedCodec
     * @return \StructType\OXPhone
     */
    public function setMtpPreferedCodec(\StructType\OXFkType $mtpPreferedCodec = null)
    {
        $this->mtpPreferedCodec = $mtpPreferedCodec;
        return $this;
    }
    /**
     * Get dialRulesName value
     * @return \StructType\OXFkTypeProduct|null
     */
    public function getDialRulesName()
    {
        return $this->dialRulesName;
    }
    /**
     * Set dialRulesName value
     * @param \StructType\OXFkTypeProduct $dialRulesName
     * @return \StructType\OXPhone
     */
    public function setDialRulesName(\StructType\OXFkTypeProduct $dialRulesName = null)
    {
        $this->dialRulesName = $dialRulesName;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return \StructType\OXFkType|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @param \StructType\OXFkType $outboundCallRollover
     * @return \StructType\OXPhone
     */
    public function setOutboundCallRollover(\StructType\OXFkType $outboundCallRollover = null)
    {
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return \StructType\OXFkType|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param \StructType\OXFkType $alwaysUsePrimeLine
     * @return \StructType\OXPhone
     */
    public function setAlwaysUsePrimeLine(\StructType\OXFkType $alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return \StructType\OXFkType|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param \StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @return \StructType\OXPhone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage(\StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \StructType\OXFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \StructType\OXFkType $featureControlPolicy
     * @return \StructType\OXPhone
     */
    public function setFeatureControlPolicy(\StructType\OXFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get deviceTrustMode value
     * @return \StructType\OXFkType|null
     */
    public function getDeviceTrustMode()
    {
        return $this->deviceTrustMode;
    }
    /**
     * Set deviceTrustMode value
     * @param \StructType\OXFkType $deviceTrustMode
     * @return \StructType\OXPhone
     */
    public function setDeviceTrustMode(\StructType\OXFkType $deviceTrustMode = null)
    {
        $this->deviceTrustMode = $deviceTrustMode;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\OXPhone
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get cgpnIngressDN value
     * @return \StructType\OXFkType|null
     */
    public function getCgpnIngressDN()
    {
        return $this->cgpnIngressDN;
    }
    /**
     * Set cgpnIngressDN value
     * @param \StructType\OXFkType $cgpnIngressDN
     * @return \StructType\OXPhone
     */
    public function setCgpnIngressDN(\StructType\OXFkType $cgpnIngressDN = null)
    {
        $this->cgpnIngressDN = $cgpnIngressDN;
        return $this;
    }
    /**
     * Get wifiHotspotProfile value
     * @return \StructType\OXFkType|null
     */
    public function getWifiHotspotProfile()
    {
        return $this->wifiHotspotProfile;
    }
    /**
     * Set wifiHotspotProfile value
     * @param \StructType\OXFkType $wifiHotspotProfile
     * @return \StructType\OXPhone
     */
    public function setWifiHotspotProfile(\StructType\OXFkType $wifiHotspotProfile = null)
    {
        $this->wifiHotspotProfile = $wifiHotspotProfile;
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * @return \StructType\OXFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return $this->wirelessLanProfileGroup;
    }
    /**
     * Set wirelessLanProfileGroup value
     * @param \StructType\OXFkType $wirelessLanProfileGroup
     * @return \StructType\OXPhone
     */
    public function setWirelessLanProfileGroup(\StructType\OXFkType $wirelessLanProfileGroup = null)
    {
        $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        return $this;
    }
    /**
     * Get elinGroup value
     * @return \StructType\OXFkType|null
     */
    public function getElinGroup()
    {
        return $this->elinGroup;
    }
    /**
     * Set elinGroup value
     * @param \StructType\OXFkType $elinGroup
     * @return \StructType\OXPhone
     */
    public function setElinGroup(\StructType\OXFkType $elinGroup = null)
    {
        $this->elinGroup = $elinGroup;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\OXPhone
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\OXPhone
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OXPhone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
