<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORBusyLampField StructType
 * @subpackage Structs
 */
class ORBusyLampField extends AbstractStructBase
{
    /**
     * The blfDirn
     * Meta informations extracted from the WSDL
     * - documentation: Either blfDest or the combination of blfDirn and routePartition is to be mentioned in the add/update request, if both are mentioned AXL will read only the blfDest tag and ignore blfDirn and routePartition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $blfDirn;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routePartition;
    /**
     * Constructor method for ORBusyLampField
     * @uses ORBusyLampField::setBlfDirn()
     * @uses ORBusyLampField::setRoutePartition()
     * @param string $blfDirn
     * @param string $routePartition
     */
    public function __construct($blfDirn = null, $routePartition = null)
    {
        $this
            ->setBlfDirn($blfDirn)
            ->setRoutePartition($routePartition);
    }
    /**
     * Get blfDirn value
     * @return string|null
     */
    public function getBlfDirn()
    {
        return $this->blfDirn;
    }
    /**
     * Set blfDirn value
     * @param string $blfDirn
     * @return \StructType\ORBusyLampField
     */
    public function setBlfDirn($blfDirn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($blfDirn) && strlen($blfDirn) > 255) || (is_array($blfDirn) && count($blfDirn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($blfDirn) ? strlen($blfDirn) : count($blfDirn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($blfDirn) && !is_string($blfDirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blfDirn)), __LINE__);
        }
        $this->blfDirn = $blfDirn;
        return $this;
    }
    /**
     * Get routePartition value
     * @return string|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param string $routePartition
     * @return \StructType\ORBusyLampField
     */
    public function setRoutePartition($routePartition = null)
    {
        // validation for constraint: string
        if (!is_null($routePartition) && !is_string($routePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePartition)), __LINE__);
        }
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ORBusyLampField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
