<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for locales StructType
 * @subpackage Structs
 */
class Locales extends XCommonMembersExtension
{
    /**
     * The locale
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XMobileVoiceMember[]
     */
    public $locale;
    /**
     * Constructor method for locales
     * @uses Locales::setLocale()
     * @param \StructType\XMobileVoiceMember[] $locale
     */
    public function __construct(array $locale = array())
    {
        $this
            ->setLocale($locale);
    }
    /**
     * Get locale value
     * @return \StructType\XMobileVoiceMember[]|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @throws \InvalidArgumentException
     * @param \StructType\XMobileVoiceMember[] $locale
     * @return \StructType\Locales
     */
    public function setLocale(array $locale = array())
    {
        foreach ($locale as $localesLocaleItem) {
            // validation for constraint: itemType
            if (!$localesLocaleItem instanceof \StructType\XMobileVoiceMember) {
                throw new \InvalidArgumentException(sprintf('The locale property can only contain items of \StructType\XMobileVoiceMember, "%s" given', is_object($localesLocaleItem) ? get_class($localesLocaleItem) : gettype($localesLocaleItem)), __LINE__);
            }
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Add item to locale value
     * @throws \InvalidArgumentException
     * @param \StructType\XMobileVoiceMember $item
     * @return \StructType\Locales
     */
    public function addToLocale(\StructType\XMobileVoiceMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XMobileVoiceMember) {
            throw new \InvalidArgumentException(sprintf('The locale property can only contain items of \StructType\XMobileVoiceMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->locale[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Locales
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
