<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LWirelessLanProfileGroup StructType
 * @subpackage Structs
 */
class LWirelessLanProfileGroup extends AbstractStructBase
{
    /**
     * The wirelessProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $wirelessProfile;
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LWirelessLanProfileGroup
     * @uses LWirelessLanProfileGroup::setWirelessProfile()
     * @uses LWirelessLanProfileGroup::setIndex()
     * @uses LWirelessLanProfileGroup::setUuid()
     * @param \StructType\XFkType $wirelessProfile
     * @param string $index
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $wirelessProfile = null, $index = null, $uuid = null)
    {
        $this
            ->setWirelessProfile($wirelessProfile)
            ->setIndex($index)
            ->setUuid($uuid);
    }
    /**
     * Get wirelessProfile value
     * @return \StructType\XFkType|null
     */
    public function getWirelessProfile()
    {
        return $this->wirelessProfile;
    }
    /**
     * Set wirelessProfile value
     * @param \StructType\XFkType $wirelessProfile
     * @return \StructType\LWirelessLanProfileGroup
     */
    public function setWirelessProfile(\StructType\XFkType $wirelessProfile = null)
    {
        $this->wirelessProfile = $wirelessProfile;
        return $this;
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\LWirelessLanProfileGroup
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LWirelessLanProfileGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LWirelessLanProfileGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
