<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSafForwarder StructType
 * @subpackage Structs
 */
class LSafForwarder extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The clientLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $clientLabel;
    /**
     * The safSecurityProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $safSecurityProfile;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The enableTcpKeepAlive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTcpKeepAlive;
    /**
     * The safReconnectInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safReconnectInterval;
    /**
     * The safNotificationsWindowSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safNotificationsWindowSize;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSafForwarder
     * @uses LSafForwarder::setName()
     * @uses LSafForwarder::setDescription()
     * @uses LSafForwarder::setClientLabel()
     * @uses LSafForwarder::setSafSecurityProfile()
     * @uses LSafForwarder::setIpAddress()
     * @uses LSafForwarder::setPort()
     * @uses LSafForwarder::setEnableTcpKeepAlive()
     * @uses LSafForwarder::setSafReconnectInterval()
     * @uses LSafForwarder::setSafNotificationsWindowSize()
     * @uses LSafForwarder::setUuid()
     * @param string $name
     * @param string $description
     * @param string $clientLabel
     * @param \StructType\XFkType $safSecurityProfile
     * @param string $ipAddress
     * @param string $port
     * @param string $enableTcpKeepAlive
     * @param string $safReconnectInterval
     * @param string $safNotificationsWindowSize
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $clientLabel = null, \StructType\XFkType $safSecurityProfile = null, $ipAddress = null, $port = null, $enableTcpKeepAlive = null, $safReconnectInterval = null, $safNotificationsWindowSize = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setClientLabel($clientLabel)
            ->setSafSecurityProfile($safSecurityProfile)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setEnableTcpKeepAlive($enableTcpKeepAlive)
            ->setSafReconnectInterval($safReconnectInterval)
            ->setSafNotificationsWindowSize($safNotificationsWindowSize)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LSafForwarder
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LSafForwarder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get clientLabel value
     * @return string|null
     */
    public function getClientLabel()
    {
        return $this->clientLabel;
    }
    /**
     * Set clientLabel value
     * @param string $clientLabel
     * @return \StructType\LSafForwarder
     */
    public function setClientLabel($clientLabel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clientLabel) && strlen($clientLabel) > 255) || (is_array($clientLabel) && count($clientLabel) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clientLabel) ? strlen($clientLabel) : count($clientLabel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clientLabel) && !is_string($clientLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientLabel)), __LINE__);
        }
        $this->clientLabel = $clientLabel;
        return $this;
    }
    /**
     * Get safSecurityProfile value
     * @return \StructType\XFkType|null
     */
    public function getSafSecurityProfile()
    {
        return $this->safSecurityProfile;
    }
    /**
     * Set safSecurityProfile value
     * @param \StructType\XFkType $safSecurityProfile
     * @return \StructType\LSafForwarder
     */
    public function setSafSecurityProfile(\StructType\XFkType $safSecurityProfile = null)
    {
        $this->safSecurityProfile = $safSecurityProfile;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\LSafForwarder
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipAddress) && strlen($ipAddress) > 255) || (is_array($ipAddress) && count($ipAddress) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($ipAddress) ? strlen($ipAddress) : count($ipAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\LSafForwarder
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get enableTcpKeepAlive value
     * @return string|null
     */
    public function getEnableTcpKeepAlive()
    {
        return $this->enableTcpKeepAlive;
    }
    /**
     * Set enableTcpKeepAlive value
     * @param string $enableTcpKeepAlive
     * @return \StructType\LSafForwarder
     */
    public function setEnableTcpKeepAlive($enableTcpKeepAlive = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableTcpKeepAlive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableTcpKeepAlive, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableTcpKeepAlive) && !is_string($enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableTcpKeepAlive)), __LINE__);
        }
        $this->enableTcpKeepAlive = $enableTcpKeepAlive;
        return $this;
    }
    /**
     * Get safReconnectInterval value
     * @return string|null
     */
    public function getSafReconnectInterval()
    {
        return $this->safReconnectInterval;
    }
    /**
     * Set safReconnectInterval value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safReconnectInterval
     * @return \StructType\LSafForwarder
     */
    public function setSafReconnectInterval($safReconnectInterval = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($safReconnectInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $safReconnectInterval, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->safReconnectInterval = $safReconnectInterval;
        return $this;
    }
    /**
     * Get safNotificationsWindowSize value
     * @return string|null
     */
    public function getSafNotificationsWindowSize()
    {
        return $this->safNotificationsWindowSize;
    }
    /**
     * Set safNotificationsWindowSize value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safNotificationsWindowSize
     * @return \StructType\LSafForwarder
     */
    public function setSafNotificationsWindowSize($safNotificationsWindowSize = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($safNotificationsWindowSize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $safNotificationsWindowSize, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->safNotificationsWindowSize = $safNotificationsWindowSize;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LSafForwarder
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LSafForwarder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
