<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LPatternMember StructType
 * @subpackage Structs
 */
class LPatternMember extends AbstractStructBase
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The dialParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DialParameters
     */
    public $dialParameters;
    /**
     * The selectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selectionOrder;
    /**
     * Constructor method for LPatternMember
     * @uses LPatternMember::setDescription()
     * @uses LPatternMember::setDialParameters()
     * @uses LPatternMember::setSelectionOrder()
     * @param string $description
     * @param \StructType\DialParameters $dialParameters
     * @param string $selectionOrder
     */
    public function __construct($description = null, \StructType\DialParameters $dialParameters = null, $selectionOrder = null)
    {
        $this
            ->setDescription($description)
            ->setDialParameters($dialParameters)
            ->setSelectionOrder($selectionOrder);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LPatternMember
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dialParameters value
     * @return \StructType\DialParameters|null
     */
    public function getDialParameters()
    {
        return $this->dialParameters;
    }
    /**
     * Set dialParameters value
     * @param \StructType\DialParameters $dialParameters
     * @return \StructType\LPatternMember
     */
    public function setDialParameters(\StructType\DialParameters $dialParameters = null)
    {
        $this->dialParameters = $dialParameters;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string|null
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \StructType\LPatternMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionOrder, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LPatternMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
