<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLicensedUser StructType
 * @subpackage Structs
 */
class LLicensedUser extends AbstractStructBase
{
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The snrEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $snrEnabled;
    /**
     * The deviceCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceCount;
    /**
     * The licenseType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $licenseType;
    /**
     * The licenseUsed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $licenseUsed;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLicensedUser
     * @uses LLicensedUser::setUserId()
     * @uses LLicensedUser::setFirstName()
     * @uses LLicensedUser::setLastName()
     * @uses LLicensedUser::setSnrEnabled()
     * @uses LLicensedUser::setDeviceCount()
     * @uses LLicensedUser::setLicenseType()
     * @uses LLicensedUser::setLicenseUsed()
     * @uses LLicensedUser::setUuid()
     * @param string $userId
     * @param string $firstName
     * @param string $lastName
     * @param string $snrEnabled
     * @param string $deviceCount
     * @param string $licenseType
     * @param string $licenseUsed
     * @param string $uuid
     */
    public function __construct($userId = null, $firstName = null, $lastName = null, $snrEnabled = null, $deviceCount = null, $licenseType = null, $licenseUsed = null, $uuid = null)
    {
        $this
            ->setUserId($userId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setSnrEnabled($snrEnabled)
            ->setDeviceCount($deviceCount)
            ->setLicenseType($licenseType)
            ->setLicenseUsed($licenseUsed)
            ->setUuid($uuid);
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\LLicensedUser
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\LLicensedUser
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\LLicensedUser
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get snrEnabled value
     * @return string|null
     */
    public function getSnrEnabled()
    {
        return $this->snrEnabled;
    }
    /**
     * Set snrEnabled value
     * @param string $snrEnabled
     * @return \StructType\LLicensedUser
     */
    public function setSnrEnabled($snrEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($snrEnabled) && !is_string($snrEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($snrEnabled)), __LINE__);
        }
        $this->snrEnabled = $snrEnabled;
        return $this;
    }
    /**
     * Get deviceCount value
     * @return string|null
     */
    public function getDeviceCount()
    {
        return $this->deviceCount;
    }
    /**
     * Set deviceCount value
     * @param string $deviceCount
     * @return \StructType\LLicensedUser
     */
    public function setDeviceCount($deviceCount = null)
    {
        // validation for constraint: string
        if (!is_null($deviceCount) && !is_string($deviceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceCount)), __LINE__);
        }
        $this->deviceCount = $deviceCount;
        return $this;
    }
    /**
     * Get licenseType value
     * @return string|null
     */
    public function getLicenseType()
    {
        return $this->licenseType;
    }
    /**
     * Set licenseType value
     * @param string $licenseType
     * @return \StructType\LLicensedUser
     */
    public function setLicenseType($licenseType = null)
    {
        // validation for constraint: string
        if (!is_null($licenseType) && !is_string($licenseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseType)), __LINE__);
        }
        $this->licenseType = $licenseType;
        return $this;
    }
    /**
     * Get licenseUsed value
     * @return string|null
     */
    public function getLicenseUsed()
    {
        return $this->licenseUsed;
    }
    /**
     * Set licenseUsed value
     * @param string $licenseUsed
     * @return \StructType\LLicensedUser
     */
    public function setLicenseUsed($licenseUsed = null)
    {
        // validation for constraint: string
        if (!is_null($licenseUsed) && !is_string($licenseUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseUsed)), __LINE__);
        }
        $this->licenseUsed = $licenseUsed;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LLicensedUser
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LLicensedUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
