<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LFeatureControlConfig StructType
 * @subpackage Structs
 */
class LFeatureControlConfig extends AbstractStructBase
{
    /**
     * The featureName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $featureName;
    /**
     * The defaultValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $defaultValue;
    /**
     * The overrideDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $overrideDefault;
    /**
     * The enableSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag will be taken to consideration only when 'overrideDefault' tag is set to True.This will be handled in the code.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableSetting;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LFeatureControlConfig
     * @uses LFeatureControlConfig::setFeatureName()
     * @uses LFeatureControlConfig::setDefaultValue()
     * @uses LFeatureControlConfig::setOverrideDefault()
     * @uses LFeatureControlConfig::setEnableSetting()
     * @uses LFeatureControlConfig::setUuid()
     * @param string $featureName
     * @param string $defaultValue
     * @param string $overrideDefault
     * @param string $enableSetting
     * @param string $uuid
     */
    public function __construct($featureName = null, $defaultValue = null, $overrideDefault = null, $enableSetting = null, $uuid = null)
    {
        $this
            ->setFeatureName($featureName)
            ->setDefaultValue($defaultValue)
            ->setOverrideDefault($overrideDefault)
            ->setEnableSetting($enableSetting)
            ->setUuid($uuid);
    }
    /**
     * Get featureName value
     * @return string|null
     */
    public function getFeatureName()
    {
        return $this->featureName;
    }
    /**
     * Set featureName value
     * @param string $featureName
     * @return \StructType\LFeatureControlConfig
     */
    public function setFeatureName($featureName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($featureName) && strlen($featureName) > 50) || (is_array($featureName) && count($featureName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($featureName) ? strlen($featureName) : count($featureName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($featureName) && !is_string($featureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($featureName)), __LINE__);
        }
        $this->featureName = $featureName;
        return $this;
    }
    /**
     * Get defaultValue value
     * @return string|null
     */
    public function getDefaultValue()
    {
        return $this->defaultValue;
    }
    /**
     * Set defaultValue value
     * @param string $defaultValue
     * @return \StructType\LFeatureControlConfig
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: pattern
        if (is_scalar($defaultValue) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $defaultValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($defaultValue, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($defaultValue) && !is_string($defaultValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultValue)), __LINE__);
        }
        $this->defaultValue = $defaultValue;
        return $this;
    }
    /**
     * Get overrideDefault value
     * @return string|null
     */
    public function getOverrideDefault()
    {
        return $this->overrideDefault;
    }
    /**
     * Set overrideDefault value
     * @param string $overrideDefault
     * @return \StructType\LFeatureControlConfig
     */
    public function setOverrideDefault($overrideDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($overrideDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $overrideDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($overrideDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($overrideDefault) && !is_string($overrideDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overrideDefault)), __LINE__);
        }
        $this->overrideDefault = $overrideDefault;
        return $this;
    }
    /**
     * Get enableSetting value
     * @return string|null
     */
    public function getEnableSetting()
    {
        return $this->enableSetting;
    }
    /**
     * Set enableSetting value
     * @param string $enableSetting
     * @return \StructType\LFeatureControlConfig
     */
    public function setEnableSetting($enableSetting = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableSetting) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableSetting, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableSetting) && !is_string($enableSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableSetting)), __LINE__);
        }
        $this->enableSetting = $enableSetting;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LFeatureControlConfig
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LFeatureControlConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
