<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDateTimeGroup StructType
 * @subpackage Structs
 */
class LDateTimeGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeZone;
    /**
     * The dateformat
     * Meta informations extracted from the WSDL
     * - documentation: It can be one among D/M/Y,M/D/Y,Y/M/D
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dateformat;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDateTimeGroup
     * @uses LDateTimeGroup::setName()
     * @uses LDateTimeGroup::setTimeZone()
     * @uses LDateTimeGroup::setDateformat()
     * @uses LDateTimeGroup::setUuid()
     * @param string $name
     * @param string $timeZone
     * @param string $dateformat
     * @param string $uuid
     */
    public function __construct($name = null, $timeZone = null, $dateformat = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setTimeZone($timeZone)
            ->setDateformat($dateformat)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LDateTimeGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \EnumType\XTimeZone::valueIsValid()
     * @uses \EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \StructType\LDateTimeGroup
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', \EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get dateformat value
     * @return string|null
     */
    public function getDateformat()
    {
        return $this->dateformat;
    }
    /**
     * Set dateformat value
     * @param string $dateformat
     * @return \StructType\LDateTimeGroup
     */
    public function setDateformat($dateformat = null)
    {
        // validation for constraint: string
        if (!is_null($dateformat) && !is_string($dateformat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateformat)), __LINE__);
        }
        $this->dateformat = $dateformat;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LDateTimeGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LDateTimeGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
