<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPhoneOptionsReq StructType
 * @subpackage Structs
 */
class GetPhoneOptionsReq extends AbstractStructBase
{
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedChoices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OXPhone
     */
    public $returnedChoices;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetPhoneOptionsReq
     * @uses GetPhoneOptionsReq::setUuid()
     * @uses GetPhoneOptionsReq::setReturnedChoices()
     * @uses GetPhoneOptionsReq::setSequence()
     * @param string $uuid
     * @param \StructType\OXPhone $returnedChoices
     * @param int $sequence
     */
    public function __construct($uuid = null, \StructType\OXPhone $returnedChoices = null, $sequence = null)
    {
        $this
            ->setUuid($uuid)
            ->setReturnedChoices($returnedChoices)
            ->setSequence($sequence);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\GetPhoneOptionsReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get returnedChoices value
     * @return \StructType\OXPhone|null
     */
    public function getReturnedChoices()
    {
        return $this->returnedChoices;
    }
    /**
     * Set returnedChoices value
     * @param \StructType\OXPhone $returnedChoices
     * @return \StructType\GetPhoneOptionsReq
     */
    public function setReturnedChoices(\StructType\OXPhone $returnedChoices = null)
    {
        $this->returnedChoices = $returnedChoices;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\GetPhoneOptionsReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPhoneOptionsReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
