<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPageLayoutPreferencesReq StructType
 * @subpackage Structs
 */
class GetPageLayoutPreferencesReq extends APIRequest
{
    /**
     * The pageName
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $pageName;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RPageLayoutPreferences
     */
    public $returnedTags;
    /**
     * Constructor method for GetPageLayoutPreferencesReq
     * @uses GetPageLayoutPreferencesReq::setPageName()
     * @uses GetPageLayoutPreferencesReq::setReturnedTags()
     * @param string $pageName
     * @param \StructType\RPageLayoutPreferences $returnedTags
     */
    public function __construct($pageName = null, \StructType\RPageLayoutPreferences $returnedTags = null)
    {
        $this
            ->setPageName($pageName)
            ->setReturnedTags($returnedTags);
    }
    /**
     * Get pageName value
     * @return string|null
     */
    public function getPageName()
    {
        return $this->pageName;
    }
    /**
     * Set pageName value
     * @param string $pageName
     * @return \StructType\GetPageLayoutPreferencesReq
     */
    public function setPageName($pageName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pageName) && strlen($pageName) > 100) || (is_array($pageName) && count($pageName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($pageName) ? strlen($pageName) : count($pageName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pageName) && !is_string($pageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageName)), __LINE__);
        }
        $this->pageName = $pageName;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \StructType\RPageLayoutPreferences|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \StructType\RPageLayoutPreferences $returnedTags
     * @return \StructType\GetPageLayoutPreferencesReq
     */
    public function setReturnedTags(\StructType\RPageLayoutPreferences $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPageLayoutPreferencesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
