<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMobilityReq StructType
 * Meta informations extracted from the WSDL
 * - documentation: Retrieves mobility configuration information. | It is mandatory to give either handoffNumber or DTMFNumber tag in the request. Both can't be null.
 * @subpackage Structs
 */
class GetMobilityReq extends AbstractStructBase
{
    /**
     * The handoffNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $handoffNumber;
    /**
     * The DTMFNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $DTMFNumber;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RMobility
     */
    public $returnedTags;
    /**
     * Constructor method for GetMobilityReq
     * @uses GetMobilityReq::setHandoffNumber()
     * @uses GetMobilityReq::setDTMFNumber()
     * @uses GetMobilityReq::setReturnedTags()
     * @param \StructType\XFkType $handoffNumber
     * @param \StructType\XFkType $dTMFNumber
     * @param \StructType\RMobility $returnedTags
     */
    public function __construct(\StructType\XFkType $handoffNumber = null, \StructType\XFkType $dTMFNumber = null, \StructType\RMobility $returnedTags = null)
    {
        $this
            ->setHandoffNumber($handoffNumber)
            ->setDTMFNumber($dTMFNumber)
            ->setReturnedTags($returnedTags);
    }
    /**
     * Get handoffNumber value
     * @return \StructType\XFkType|null
     */
    public function getHandoffNumber()
    {
        return $this->handoffNumber;
    }
    /**
     * Set handoffNumber value
     * @param \StructType\XFkType $handoffNumber
     * @return \StructType\GetMobilityReq
     */
    public function setHandoffNumber(\StructType\XFkType $handoffNumber = null)
    {
        $this->handoffNumber = $handoffNumber;
        return $this;
    }
    /**
     * Get DTMFNumber value
     * @return \StructType\XFkType|null
     */
    public function getDTMFNumber()
    {
        return $this->DTMFNumber;
    }
    /**
     * Set DTMFNumber value
     * @param \StructType\XFkType $dTMFNumber
     * @return \StructType\GetMobilityReq
     */
    public function setDTMFNumber(\StructType\XFkType $dTMFNumber = null)
    {
        $this->DTMFNumber = $dTMFNumber;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \StructType\RMobility|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \StructType\RMobility $returnedTags
     * @return \StructType\GetMobilityReq
     */
    public function setReturnedTags(\StructType\RMobility $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMobilityReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
