<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConferenceNowReq StructType
 * @subpackage Structs
 */
class GetConferenceNowReq extends AbstractStructBase
{
    /**
     * The conferenceNowNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $conferenceNowNumber;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RConferenceNow
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetConferenceNowReq
     * @uses GetConferenceNowReq::setConferenceNowNumber()
     * @uses GetConferenceNowReq::setUuid()
     * @uses GetConferenceNowReq::setRoutePartitionName()
     * @uses GetConferenceNowReq::setReturnedTags()
     * @uses GetConferenceNowReq::setSequence()
     * @param string $conferenceNowNumber
     * @param string $uuid
     * @param \StructType\XFkType $routePartitionName
     * @param \StructType\RConferenceNow $returnedTags
     * @param int $sequence
     */
    public function __construct($conferenceNowNumber = null, $uuid = null, \StructType\XFkType $routePartitionName = null, \StructType\RConferenceNow $returnedTags = null, $sequence = null)
    {
        $this
            ->setConferenceNowNumber($conferenceNowNumber)
            ->setUuid($uuid)
            ->setRoutePartitionName($routePartitionName)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get conferenceNowNumber value
     * @return string
     */
    public function getConferenceNowNumber()
    {
        return $this->conferenceNowNumber;
    }
    /**
     * Set conferenceNowNumber value
     * @param string $conferenceNowNumber
     * @return \StructType\GetConferenceNowReq
     */
    public function setConferenceNowNumber($conferenceNowNumber = null)
    {
        // validation for constraint: string
        if (!is_null($conferenceNowNumber) && !is_string($conferenceNowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conferenceNowNumber)), __LINE__);
        }
        $this->conferenceNowNumber = $conferenceNowNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\GetConferenceNowReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\GetConferenceNowReq
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \StructType\RConferenceNow|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \StructType\RConferenceNow $returnedTags
     * @return \StructType\GetConferenceNowReq
     */
    public function setReturnedTags(\StructType\RConferenceNow $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\GetConferenceNowReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetConferenceNowReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
