<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for enterpriseAltNum StructType
 * Meta informations extracted from the WSDL
 * - documentation: Applicable only for Update and Get Request | Applicable only for Update and Get Request | Applicable only for Update and Get Request | Applicable only for Update and Get Request | Applicable only for Update and Get Request |
 * Applicable only for Update and Get Request
 * @subpackage Structs
 */
class EnterpriseAltNum extends AbstractStructBase
{
    /**
     * The numMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numMask;
    /**
     * The isUrgent
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isUrgent;
    /**
     * The addLocalRoutePartition
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $addLocalRoutePartition;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartition;
    /**
     * The advertiseGloballyIls
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $advertiseGloballyIls;
    /**
     * The member
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XEnterpriseAltNum
     */
    public $member;
    /**
     * Constructor method for enterpriseAltNum
     * @uses EnterpriseAltNum::setNumMask()
     * @uses EnterpriseAltNum::setIsUrgent()
     * @uses EnterpriseAltNum::setAddLocalRoutePartition()
     * @uses EnterpriseAltNum::setRoutePartition()
     * @uses EnterpriseAltNum::setAdvertiseGloballyIls()
     * @uses EnterpriseAltNum::setMember()
     * @param string $numMask
     * @param string $isUrgent
     * @param string $addLocalRoutePartition
     * @param \StructType\XFkType $routePartition
     * @param string $advertiseGloballyIls
     * @param \StructType\XEnterpriseAltNum $member
     */
    public function __construct($numMask = null, $isUrgent = false, $addLocalRoutePartition = true, \StructType\XFkType $routePartition = null, $advertiseGloballyIls = true, \StructType\XEnterpriseAltNum $member = null)
    {
        $this
            ->setNumMask($numMask)
            ->setIsUrgent($isUrgent)
            ->setAddLocalRoutePartition($addLocalRoutePartition)
            ->setRoutePartition($routePartition)
            ->setAdvertiseGloballyIls($advertiseGloballyIls)
            ->setMember($member);
    }
    /**
     * Get numMask value
     * @return string|null
     */
    public function getNumMask()
    {
        return $this->numMask;
    }
    /**
     * Set numMask value
     * @param string $numMask
     * @return \StructType\EnterpriseAltNum
     */
    public function setNumMask($numMask = null)
    {
        // validation for constraint: string
        if (!is_null($numMask) && !is_string($numMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numMask)), __LINE__);
        }
        $this->numMask = $numMask;
        return $this;
    }
    /**
     * Get isUrgent value
     * @return string|null
     */
    public function getIsUrgent()
    {
        return $this->isUrgent;
    }
    /**
     * Set isUrgent value
     * @param string $isUrgent
     * @return \StructType\EnterpriseAltNum
     */
    public function setIsUrgent($isUrgent = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isUrgent) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isUrgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isUrgent, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isUrgent) && !is_string($isUrgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isUrgent)), __LINE__);
        }
        $this->isUrgent = $isUrgent;
        return $this;
    }
    /**
     * Get addLocalRoutePartition value
     * @return string|null
     */
    public function getAddLocalRoutePartition()
    {
        return $this->addLocalRoutePartition;
    }
    /**
     * Set addLocalRoutePartition value
     * @param string $addLocalRoutePartition
     * @return \StructType\EnterpriseAltNum
     */
    public function setAddLocalRoutePartition($addLocalRoutePartition = true)
    {
        // validation for constraint: pattern
        if (is_scalar($addLocalRoutePartition) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $addLocalRoutePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($addLocalRoutePartition, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addLocalRoutePartition) && !is_string($addLocalRoutePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addLocalRoutePartition)), __LINE__);
        }
        $this->addLocalRoutePartition = $addLocalRoutePartition;
        return $this;
    }
    /**
     * Get routePartition value
     * @return \StructType\XFkType|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param \StructType\XFkType $routePartition
     * @return \StructType\EnterpriseAltNum
     */
    public function setRoutePartition(\StructType\XFkType $routePartition = null)
    {
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get advertiseGloballyIls value
     * @return string|null
     */
    public function getAdvertiseGloballyIls()
    {
        return $this->advertiseGloballyIls;
    }
    /**
     * Set advertiseGloballyIls value
     * @param string $advertiseGloballyIls
     * @return \StructType\EnterpriseAltNum
     */
    public function setAdvertiseGloballyIls($advertiseGloballyIls = true)
    {
        // validation for constraint: pattern
        if (is_scalar($advertiseGloballyIls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $advertiseGloballyIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($advertiseGloballyIls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($advertiseGloballyIls) && !is_string($advertiseGloballyIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advertiseGloballyIls)), __LINE__);
        }
        $this->advertiseGloballyIls = $advertiseGloballyIls;
        return $this;
    }
    /**
     * Get member value
     * @return \StructType\XEnterpriseAltNum|null
     */
    public function getMember()
    {
        return $this->member;
    }
    /**
     * Set member value
     * @param \StructType\XEnterpriseAltNum $member
     * @return \StructType\EnterpriseAltNum
     */
    public function setMember(\StructType\XEnterpriseAltNum $member = null)
    {
        $this->member = $member;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EnterpriseAltNum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
