<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoDeviceLoginReq StructType
 * Meta informations extracted from the WSDL
 * - documentation: Logs-in the specified user to the specified phone.
 * @subpackage Structs
 */
class DoDeviceLoginReq extends APIRequest
{
    /**
     * The deviceName
     * Meta informations extracted from the WSDL
     * - documentation: The name or uuid of the phone that is being logged-into. Not nullable.
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $deviceName;
    /**
     * The loginDuration
     * Meta informations extracted from the WSDL
     * - documentation: The duration of the login. Not nullable.
     * - nillable: false
     * @var int
     */
    public $loginDuration;
    /**
     * The profileName
     * Meta informations extracted from the WSDL
     * - documentation: The name or uuid of the Device Profile to be used. Not nullable.
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $profileName;
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - documentation: The LDAP RN of the user that is to be logged-into the phone. Not nullable.
     * - nillable: false
     * @var string
     */
    public $userId;
    /**
     * Constructor method for DoDeviceLoginReq
     * @uses DoDeviceLoginReq::setDeviceName()
     * @uses DoDeviceLoginReq::setLoginDuration()
     * @uses DoDeviceLoginReq::setProfileName()
     * @uses DoDeviceLoginReq::setUserId()
     * @param \StructType\XFkType $deviceName
     * @param int $loginDuration
     * @param \StructType\XFkType $profileName
     * @param string $userId
     */
    public function __construct(\StructType\XFkType $deviceName = null, $loginDuration = null, \StructType\XFkType $profileName = null, $userId = null)
    {
        $this
            ->setDeviceName($deviceName)
            ->setLoginDuration($loginDuration)
            ->setProfileName($profileName)
            ->setUserId($userId);
    }
    /**
     * Get deviceName value
     * @return \StructType\XFkType|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param \StructType\XFkType $deviceName
     * @return \StructType\DoDeviceLoginReq
     */
    public function setDeviceName(\StructType\XFkType $deviceName = null)
    {
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get loginDuration value
     * @return int|null
     */
    public function getLoginDuration()
    {
        return $this->loginDuration;
    }
    /**
     * Set loginDuration value
     * @param int $loginDuration
     * @return \StructType\DoDeviceLoginReq
     */
    public function setLoginDuration($loginDuration = null)
    {
        // validation for constraint: int
        if (!is_null($loginDuration) && !is_numeric($loginDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($loginDuration)), __LINE__);
        }
        $this->loginDuration = $loginDuration;
        return $this;
    }
    /**
     * Get profileName value
     * @return \StructType\XFkType|null
     */
    public function getProfileName()
    {
        return $this->profileName;
    }
    /**
     * Set profileName value
     * @param \StructType\XFkType $profileName
     * @return \StructType\DoDeviceLoginReq
     */
    public function setProfileName(\StructType\XFkType $profileName = null)
    {
        $this->profileName = $profileName;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\DoDeviceLoginReq
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoDeviceLoginReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
