<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ctiControlledDeviceProfiles StructType
 * @subpackage Structs
 */
class CtiControlledDeviceProfiles extends AbstractStructBase
{
    /**
     * The profileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XFkType[]
     */
    public $profileName;
    /**
     * The deviceProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 50
     * @var string[]
     */
    public $deviceProfile;
    /**
     * Constructor method for ctiControlledDeviceProfiles
     * @uses CtiControlledDeviceProfiles::setProfileName()
     * @uses CtiControlledDeviceProfiles::setDeviceProfile()
     * @param \StructType\XFkType[] $profileName
     * @param string[] $deviceProfile
     */
    public function __construct(array $profileName = array(), array $deviceProfile = array())
    {
        $this
            ->setProfileName($profileName)
            ->setDeviceProfile($deviceProfile);
    }
    /**
     * Get profileName value
     * @return \StructType\XFkType[]|null
     */
    public function getProfileName()
    {
        return $this->profileName;
    }
    /**
     * Set profileName value
     * @throws \InvalidArgumentException
     * @param \StructType\XFkType[] $profileName
     * @return \StructType\CtiControlledDeviceProfiles
     */
    public function setProfileName(array $profileName = array())
    {
        foreach ($profileName as $ctiControlledDeviceProfilesProfileNameItem) {
            // validation for constraint: itemType
            if (!$ctiControlledDeviceProfilesProfileNameItem instanceof \StructType\XFkType) {
                throw new \InvalidArgumentException(sprintf('The profileName property can only contain items of \StructType\XFkType, "%s" given', is_object($ctiControlledDeviceProfilesProfileNameItem) ? get_class($ctiControlledDeviceProfilesProfileNameItem) : gettype($ctiControlledDeviceProfilesProfileNameItem)), __LINE__);
            }
        }
        $this->profileName = $profileName;
        return $this;
    }
    /**
     * Add item to profileName value
     * @throws \InvalidArgumentException
     * @param \StructType\XFkType $item
     * @return \StructType\CtiControlledDeviceProfiles
     */
    public function addToProfileName(\StructType\XFkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XFkType) {
            throw new \InvalidArgumentException(sprintf('The profileName property can only contain items of \StructType\XFkType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->profileName[] = $item;
        return $this;
    }
    /**
     * Get deviceProfile value
     * @return string[]|null
     */
    public function getDeviceProfile()
    {
        return $this->deviceProfile;
    }
    /**
     * Set deviceProfile value
     * @throws \InvalidArgumentException
     * @param string[] $deviceProfile
     * @return \StructType\CtiControlledDeviceProfiles
     */
    public function setDeviceProfile(array $deviceProfile = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($deviceProfile) && strlen($deviceProfile) > 50) || (is_array($deviceProfile) && count($deviceProfile) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($deviceProfile) ? strlen($deviceProfile) : count($deviceProfile)), __LINE__);
        }
        foreach ($deviceProfile as $ctiControlledDeviceProfilesDeviceProfileItem) {
            // validation for constraint: itemType
            if (!is_string($ctiControlledDeviceProfilesDeviceProfileItem)) {
                throw new \InvalidArgumentException(sprintf('The deviceProfile property can only contain items of string, "%s" given', is_object($ctiControlledDeviceProfilesDeviceProfileItem) ? get_class($ctiControlledDeviceProfilesDeviceProfileItem) : gettype($ctiControlledDeviceProfilesDeviceProfileItem)), __LINE__);
            }
        }
        $this->deviceProfile = $deviceProfile;
        return $this;
    }
    /**
     * Add item to deviceProfile value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CtiControlledDeviceProfiles
     */
    public function addToDeviceProfile($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 50) || (is_array($item) && count($item) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The deviceProfile property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->deviceProfile[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CtiControlledDeviceProfiles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
