<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedCapfProfiles StructType
 * Meta informations extracted from the WSDL
 * - documentation: Read Only.The Certification Authority Proxy Function Profiles to which the application user is associated with. | Read Only.The Certification Authority Proxy Function Profiles to which the application user is associated with.
 * @subpackage Structs
 */
class AssociatedCapfProfiles extends AbstractStructBase
{
    /**
     * The capfProfileInstanceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 128
     * @var string[]
     */
    public $capfProfileInstanceId;
    /**
     * Constructor method for associatedCapfProfiles
     * @uses AssociatedCapfProfiles::setCapfProfileInstanceId()
     * @param string[] $capfProfileInstanceId
     */
    public function __construct(array $capfProfileInstanceId = array())
    {
        $this
            ->setCapfProfileInstanceId($capfProfileInstanceId);
    }
    /**
     * Get capfProfileInstanceId value
     * @return string[]|null
     */
    public function getCapfProfileInstanceId()
    {
        return $this->capfProfileInstanceId;
    }
    /**
     * Set capfProfileInstanceId value
     * @throws \InvalidArgumentException
     * @param string[] $capfProfileInstanceId
     * @return \StructType\AssociatedCapfProfiles
     */
    public function setCapfProfileInstanceId(array $capfProfileInstanceId = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($capfProfileInstanceId) && strlen($capfProfileInstanceId) > 128) || (is_array($capfProfileInstanceId) && count($capfProfileInstanceId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($capfProfileInstanceId) ? strlen($capfProfileInstanceId) : count($capfProfileInstanceId)), __LINE__);
        }
        foreach ($capfProfileInstanceId as $associatedCapfProfilesCapfProfileInstanceIdItem) {
            // validation for constraint: itemType
            if (!is_string($associatedCapfProfilesCapfProfileInstanceIdItem)) {
                throw new \InvalidArgumentException(sprintf('The capfProfileInstanceId property can only contain items of string, "%s" given', is_object($associatedCapfProfilesCapfProfileInstanceIdItem) ? get_class($associatedCapfProfilesCapfProfileInstanceIdItem) : gettype($associatedCapfProfilesCapfProfileInstanceIdItem)), __LINE__);
            }
        }
        $this->capfProfileInstanceId = $capfProfileInstanceId;
        return $this;
    }
    /**
     * Add item to capfProfileInstanceId value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AssociatedCapfProfiles
     */
    public function addToCapfProfileInstanceId($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 128) || (is_array($item) && count($item) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The capfProfileInstanceId property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->capfProfileInstanceId[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssociatedCapfProfiles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
