<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Restart ServiceType
 * @subpackage Services
 */
class Restart extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named restartSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartSipProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartRoutePartition(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartCallManager(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartRegion(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartDevicePool(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartSoftKeyTemplate(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RestartResourcePriorityNamespaceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartResourcePriorityNamespace(\StructType\RestartResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * restartResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartResourcePriorityNamespaceList(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartSrst(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartVoiceMailProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartVoiceMailPort(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartGatekeeper(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartPhoneButtonTemplate(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartCtiRoutePoint(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartConferenceBridge(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartMtp(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RestartLineReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartLine(\StructType\RestartLineReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartH323Phone(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartH323Trunk(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartPhone(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartH323Gateway(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * restartCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartCiscoCatalyst600024PortFXSGateway(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * restartCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartCiscoCatalyst6000E1VoIPGateway(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * restartCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartCiscoCatalyst6000T1VoIPGatewayPri(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * restartCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartCiscoCatalyst6000T1VoIPGatewayT1(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named restartSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function restartSipTrunk(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->restartSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
