<?php

namespace EnumType;

/**
 * This class stands for XZzntpmode EnumType
 * @subpackage Enumerations
 */
class XZzntpmode
{
    /**
     * Constant for value 'Unicast'
     * @return string 'Unicast'
     */
    const VALUE_UNICAST = 'Unicast';
    /**
     * Constant for value 'Multicast'
     * @return string 'Multicast'
     */
    const VALUE_MULTICAST = 'Multicast';
    /**
     * Constant for value 'Anycast'
     * @return string 'Anycast'
     */
    const VALUE_ANYCAST = 'Anycast';
    /**
     * Constant for value 'Directed Broadcast'
     * @return string 'Directed Broadcast'
     */
    const VALUE_DIRECTED_BROADCAST = 'Directed Broadcast';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNICAST
     * @uses self::VALUE_MULTICAST
     * @uses self::VALUE_ANYCAST
     * @uses self::VALUE_DIRECTED_BROADCAST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNICAST,
            self::VALUE_MULTICAST,
            self::VALUE_ANYCAST,
            self::VALUE_DIRECTED_BROADCAST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
