<?php

namespace EnumType;

/**
 * This class stands for XWiFiAuthenticationMethod EnumType
 * @subpackage Enumerations
 */
class XWiFiAuthenticationMethod
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'WEP'
     * @return string 'WEP'
     */
    const VALUE_WEP = 'WEP';
    /**
     * Constant for value 'PSK'
     * @return string 'PSK'
     */
    const VALUE_PSK = 'PSK';
    /**
     * Constant for value 'EAP-FAST'
     * @return string 'EAP-FAST'
     */
    const VALUE_EAP_FAST = 'EAP-FAST';
    /**
     * Constant for value 'PEAP-MSCHAPv2'
     * @return string 'PEAP-MSCHAPv2'
     */
    const VALUE_PEAP_MSCHAPV_2 = 'PEAP-MSCHAPv2';
    /**
     * Constant for value 'PEAP-GTC'
     * @return string 'PEAP-GTC'
     */
    const VALUE_PEAP_GTC = 'PEAP-GTC';
    /**
     * Constant for value 'EAP-TLS'
     * @return string 'EAP-TLS'
     */
    const VALUE_EAP_TLS = 'EAP-TLS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_WEP
     * @uses self::VALUE_PSK
     * @uses self::VALUE_EAP_FAST
     * @uses self::VALUE_PEAP_MSCHAPV_2
     * @uses self::VALUE_PEAP_GTC
     * @uses self::VALUE_EAP_TLS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_WEP,
            self::VALUE_PSK,
            self::VALUE_EAP_FAST,
            self::VALUE_PEAP_MSCHAPV_2,
            self::VALUE_PEAP_GTC,
            self::VALUE_EAP_TLS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
