<?php

namespace EnumType;

/**
 * This class stands for XServerSecurityMode EnumType
 * @subpackage Enumerations
 */
class XServerSecurityMode
{
    /**
     * Constant for value 'Authenticated'
     * @return string 'Authenticated'
     */
    const VALUE_AUTHENTICATED = 'Authenticated';
    /**
     * Constant for value 'Encrypted and Authenticated'
     * @return string 'Encrypted and Authenticated'
     */
    const VALUE_ENCRYPTED_AND_AUTHENTICATED = 'Encrypted and Authenticated';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUTHENTICATED
     * @uses self::VALUE_ENCRYPTED_AND_AUTHENTICATED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTHENTICATED,
            self::VALUE_ENCRYPTED_AND_AUTHENTICATED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
