<?php

namespace EnumType;

/**
 * This class stands for XReset EnumType
 * @subpackage Enumerations
 */
class XReset
{
    /**
     * Constant for value 'Reset'
     * @return string 'Reset'
     */
    const VALUE_RESET = 'Reset';
    /**
     * Constant for value 'Restart'
     * @return string 'Restart'
     */
    const VALUE_RESTART = 'Restart';
    /**
     * Constant for value 'Apply Configuration'
     * @return string 'Apply Configuration'
     */
    const VALUE_APPLY_CONFIGURATION = 'Apply Configuration';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RESET
     * @uses self::VALUE_RESTART
     * @uses self::VALUE_APPLY_CONFIGURATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RESET,
            self::VALUE_RESTART,
            self::VALUE_APPLY_CONFIGURATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
