<?php

namespace EnumType;

/**
 * This class stands for XPriOfNumber EnumType
 * @subpackage Enumerations
 */
class XPriOfNumber
{
    /**
     * Constant for value 'Cisco CallManager'
     * @return string 'Cisco CallManager'
     */
    const VALUE_CISCO_CALL_MANAGER = 'Cisco CallManager';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'National'
     * @return string 'National'
     */
    const VALUE_NATIONAL = 'National';
    /**
     * Constant for value 'International'
     * @return string 'International'
     */
    const VALUE_INTERNATIONAL = 'International';
    /**
     * Constant for value 'Subscriber'
     * @return string 'Subscriber'
     */
    const VALUE_SUBSCRIBER = 'Subscriber';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CISCO_CALL_MANAGER
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_NATIONAL
     * @uses self::VALUE_INTERNATIONAL
     * @uses self::VALUE_SUBSCRIBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CISCO_CALL_MANAGER,
            self::VALUE_UNKNOWN,
            self::VALUE_NATIONAL,
            self::VALUE_INTERNATIONAL,
            self::VALUE_SUBSCRIBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
