<?php

namespace EnumType;

/**
 * This class stands for XPreferredMediaSource EnumType
 * @subpackage Enumerations
 */
class XPreferredMediaSource
{
    /**
     * Constant for value 'Gateway Preferred'
     * @return string 'Gateway Preferred'
     */
    const VALUE_GATEWAY_PREFERRED = 'Gateway Preferred';
    /**
     * Constant for value 'Phone Preferred'
     * @return string 'Phone Preferred'
     */
    const VALUE_PHONE_PREFERRED = 'Phone Preferred';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GATEWAY_PREFERRED
     * @uses self::VALUE_PHONE_PREFERRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GATEWAY_PREFERRED,
            self::VALUE_PHONE_PREFERRED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
