<?php

namespace EnumType;

/**
 * This class stands for XPatternPrecedence EnumType
 * @subpackage Enumerations
 */
class XPatternPrecedence
{
    /**
     * Constant for value 'Flash Override'
     * @return string 'Flash Override'
     */
    const VALUE_FLASH_OVERRIDE = 'Flash Override';
    /**
     * Constant for value 'Flash'
     * @return string 'Flash'
     */
    const VALUE_FLASH = 'Flash';
    /**
     * Constant for value 'Immediate'
     * @return string 'Immediate'
     */
    const VALUE_IMMEDIATE = 'Immediate';
    /**
     * Constant for value 'Priority'
     * @return string 'Priority'
     */
    const VALUE_PRIORITY = 'Priority';
    /**
     * Constant for value 'Routine'
     * @return string 'Routine'
     */
    const VALUE_ROUTINE = 'Routine';
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'Executive Override'
     * @return string 'Executive Override'
     */
    const VALUE_EXECUTIVE_OVERRIDE = 'Executive Override';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FLASH_OVERRIDE
     * @uses self::VALUE_FLASH
     * @uses self::VALUE_IMMEDIATE
     * @uses self::VALUE_PRIORITY
     * @uses self::VALUE_ROUTINE
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_EXECUTIVE_OVERRIDE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FLASH_OVERRIDE,
            self::VALUE_FLASH,
            self::VALUE_IMMEDIATE,
            self::VALUE_PRIORITY,
            self::VALUE_ROUTINE,
            self::VALUE_DEFAULT,
            self::VALUE_EXECUTIVE_OVERRIDE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
