<?php

namespace EnumType;

/**
 * This class stands for XKeySize EnumType
 * @subpackage Enumerations
 */
class XKeySize
{
    /**
     * Constant for value '512'
     * @return string '512'
     */
    const VALUE_512 = '512';
    /**
     * Constant for value '1024'
     * @return string '1024'
     */
    const VALUE_1024 = '1024';
    /**
     * Constant for value '2048'
     * @return string '2048'
     */
    const VALUE_2048 = '2048';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_512
     * @uses self::VALUE_1024
     * @uses self::VALUE_2048
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_512,
            self::VALUE_1024,
            self::VALUE_2048,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
