<?php

namespace EnumType;

/**
 * This class stands for XECKeySize EnumType
 * @subpackage Enumerations
 */
class XECKeySize
{
    /**
     * Constant for value '256'
     * @return string '256'
     */
    const VALUE_256 = '256';
    /**
     * Constant for value '384'
     * @return string '384'
     */
    const VALUE_384 = '384';
    /**
     * Constant for value '521'
     * @return string '521'
     */
    const VALUE_521 = '521';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_256
     * @uses self::VALUE_384
     * @uses self::VALUE_521
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_256,
            self::VALUE_384,
            self::VALUE_521,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
