<?php

namespace EnumType;

/**
 * This class stands for XCallingLineIdentification EnumType
 * @subpackage Enumerations
 */
class XCallingLineIdentification
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'Strict From URI presentation Only'
     * @return string 'Strict From URI presentation Only'
     */
    const VALUE_STRICT_FROM_URI_PRESENTATION_ONLY = 'Strict From URI presentation Only';
    /**
     * Constant for value 'Strict Identity Headers presentation Only'
     * @return string 'Strict Identity Headers presentation Only'
     */
    const VALUE_STRICT_IDENTITY_HEADERS_PRESENTATION_ONLY = 'Strict Identity Headers presentation Only';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_STRICT_FROM_URI_PRESENTATION_ONLY
     * @uses self::VALUE_STRICT_IDENTITY_HEADERS_PRESENTATION_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_STRICT_FROM_URI_PRESENTATION_ONLY,
            self::VALUE_STRICT_IDENTITY_HEADERS_PRESENTATION_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
