<?php

namespace EnumType;

/**
 * This class stands for XCallerID EnumType
 * @subpackage Enumerations
 */
class XCallerID
{
    /**
     * Constant for value 'ANI'
     * @return string 'ANI'
     */
    const VALUE_ANI = 'ANI';
    /**
     * Constant for value 'DNIS'
     * @return string 'DNIS'
     */
    const VALUE_DNIS = 'DNIS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ANI
     * @uses self::VALUE_DNIS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANI,
            self::VALUE_DNIS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
