<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XWLANProfile StructType
 * @subpackage Structs
 */
class XWLANProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The ssid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ssid;
    /**
     * The frequencyBand
     * Meta informations extracted from the WSDL
     * - default: Auto
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $frequencyBand;
    /**
     * The userModifiable
     * Meta informations extracted from the WSDL
     * - default: Disallowed
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userModifiable;
    /**
     * The authMethod
     * Meta informations extracted from the WSDL
     * - default: EAP-FAST
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $authMethod;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pskPassphrase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pskPassphrase;
    /**
     * The wepKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $wepKey;
    /**
     * The passwordDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $passwordDescription;
    /**
     * The networkAccessProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $networkAccessProfile;
    /**
     * Constructor method for XWLANProfile
     * @uses XWLANProfile::setName()
     * @uses XWLANProfile::setSsid()
     * @uses XWLANProfile::setFrequencyBand()
     * @uses XWLANProfile::setUserModifiable()
     * @uses XWLANProfile::setAuthMethod()
     * @uses XWLANProfile::setDescription()
     * @uses XWLANProfile::setUserName()
     * @uses XWLANProfile::setPassword()
     * @uses XWLANProfile::setPskPassphrase()
     * @uses XWLANProfile::setWepKey()
     * @uses XWLANProfile::setPasswordDescription()
     * @uses XWLANProfile::setNetworkAccessProfile()
     * @param string $name
     * @param string $ssid
     * @param string $frequencyBand
     * @param string $userModifiable
     * @param string $authMethod
     * @param string $description
     * @param string $userName
     * @param string $password
     * @param string $pskPassphrase
     * @param string $wepKey
     * @param string $passwordDescription
     * @param XFkType $networkAccessProfile
     */
    public function __construct($name = null, $ssid = null, $frequencyBand = 'Auto', $userModifiable = 'Disallowed', $authMethod = 'EAP-FAST', $description = null, $userName = null, $password = null, $pskPassphrase = null, $wepKey = null, $passwordDescription = null, XFkType $networkAccessProfile = null)
    {
        $this
            ->setName($name)
            ->setSsid($ssid)
            ->setFrequencyBand($frequencyBand)
            ->setUserModifiable($userModifiable)
            ->setAuthMethod($authMethod)
            ->setDescription($description)
            ->setUserName($userName)
            ->setPassword($password)
            ->setPskPassphrase($pskPassphrase)
            ->setWepKey($wepKey)
            ->setPasswordDescription($passwordDescription)
            ->setNetworkAccessProfile($networkAccessProfile);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XWLANProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ssid value
     * @return string
     */
    public function getSsid()
    {
        return $this->ssid;
    }
    /**
     * Set ssid value
     * @param string $ssid
     * @return XWLANProfile
     */
    public function setSsid($ssid = null)
    {
        // validation for constraint: string
        if (!is_null($ssid) && !is_string($ssid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssid)), __LINE__);
        }
        $this->ssid = $ssid;
        return $this;
    }
    /**
     * Get frequencyBand value
     * @return string
     */
    public function getFrequencyBand()
    {
        return $this->frequencyBand;
    }
    /**
     * Set frequencyBand value
     * @uses XWiFiFrequency::valueIsValid()
     * @uses XWiFiFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequencyBand
     * @return XWLANProfile
     */
    public function setFrequencyBand($frequencyBand = 'Auto')
    {
        // validation for constraint: enumeration
        if (!XWiFiFrequency::valueIsValid($frequencyBand)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $frequencyBand, implode(', ', XWiFiFrequency::getValidValues())), __LINE__);
        }
        $this->frequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get userModifiable value
     * @return string
     */
    public function getUserModifiable()
    {
        return $this->userModifiable;
    }
    /**
     * Set userModifiable value
     * @uses XWLANProfileChanges::valueIsValid()
     * @uses XWLANProfileChanges::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userModifiable
     * @return XWLANProfile
     */
    public function setUserModifiable($userModifiable = 'Disallowed')
    {
        // validation for constraint: enumeration
        if (!XWLANProfileChanges::valueIsValid($userModifiable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userModifiable, implode(', ', XWLANProfileChanges::getValidValues())), __LINE__);
        }
        $this->userModifiable = $userModifiable;
        return $this;
    }
    /**
     * Get authMethod value
     * @return string
     */
    public function getAuthMethod()
    {
        return $this->authMethod;
    }
    /**
     * Set authMethod value
     * @uses XWiFiAuthenticationMethod::valueIsValid()
     * @uses XWiFiAuthenticationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authMethod
     * @return XWLANProfile
     */
    public function setAuthMethod($authMethod = 'EAP-FAST')
    {
        // validation for constraint: enumeration
        if (!XWiFiAuthenticationMethod::valueIsValid($authMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authMethod, implode(', ', XWiFiAuthenticationMethod::getValidValues())), __LINE__);
        }
        $this->authMethod = $authMethod;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XWLANProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return XWLANProfile
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return XWLANProfile
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pskPassphrase value
     * @return string|null
     */
    public function getPskPassphrase()
    {
        return $this->pskPassphrase;
    }
    /**
     * Set pskPassphrase value
     * @param string $pskPassphrase
     * @return XWLANProfile
     */
    public function setPskPassphrase($pskPassphrase = null)
    {
        // validation for constraint: string
        if (!is_null($pskPassphrase) && !is_string($pskPassphrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pskPassphrase)), __LINE__);
        }
        $this->pskPassphrase = $pskPassphrase;
        return $this;
    }
    /**
     * Get wepKey value
     * @return string|null
     */
    public function getWepKey()
    {
        return $this->wepKey;
    }
    /**
     * Set wepKey value
     * @param string $wepKey
     * @return XWLANProfile
     */
    public function setWepKey($wepKey = null)
    {
        // validation for constraint: string
        if (!is_null($wepKey) && !is_string($wepKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wepKey)), __LINE__);
        }
        $this->wepKey = $wepKey;
        return $this;
    }
    /**
     * Get passwordDescription value
     * @return string|null
     */
    public function getPasswordDescription()
    {
        return $this->passwordDescription;
    }
    /**
     * Set passwordDescription value
     * @param string $passwordDescription
     * @return XWLANProfile
     */
    public function setPasswordDescription($passwordDescription = null)
    {
        // validation for constraint: string
        if (!is_null($passwordDescription) && !is_string($passwordDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordDescription)), __LINE__);
        }
        $this->passwordDescription = $passwordDescription;
        return $this;
    }
    /**
     * Get networkAccessProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNetworkAccessProfile()
    {
        return isset($this->networkAccessProfile) ? $this->networkAccessProfile : null;
    }
    /**
     * Set networkAccessProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $networkAccessProfile
     * @return XWLANProfile
     */
    public function setNetworkAccessProfile(XFkType $networkAccessProfile = null)
    {
        if (is_null($networkAccessProfile) || (is_array($networkAccessProfile) && empty($networkAccessProfile))) {
            unset($this->networkAccessProfile);
        } else {
            $this->networkAccessProfile = $networkAccessProfile;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XWLANProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
