<?php
/**
 * This class stands for XViprFilterElement EnumType
 * @subpackage Enumerations
 */
class XViprFilterElement
{
    /**
     * Constant for value 'Prefix'
     * @return string 'Prefix'
     */
    const VALUE_PREFIX = 'Prefix';
    /**
     * Constant for value 'Domain'
     * @return string 'Domain'
     */
    const VALUE_DOMAIN = 'Domain';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PREFIX
     * @uses self::VALUE_DOMAIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PREFIX,
            self::VALUE_DOMAIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
