<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUniversalLineTemplate StructType
 * @subpackage Structs
 */
class XUniversalLineTemplate extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The blfPresenceGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $blfPresenceGroup;
    /**
     * The partyEntranceTone
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $partyEntranceTone;
    /**
     * The autoAnswer
     * Meta informations extracted from the WSDL
     * - default: Auto Answer Off
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $autoAnswer;
    /**
     * The urgentPriority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $urgentPriority;
    /**
     * The lineDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $lineDescription;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $routePartition;
    /**
     * The voiceMailProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $voiceMailProfile;
    /**
     * The callingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpace;
    /**
     * The alertingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alertingName;
    /**
     * The extCallControlProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $extCallControlProfile;
    /**
     * The callPickupGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $callPickupGroup;
    /**
     * The rejectAnonymousCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousCall;
    /**
     * The userHoldMohAudioSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSource;
    /**
     * The networkHoldMohAudioSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSource;
    /**
     * The aarDestinationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $aarDestinationMask;
    /**
     * The aarGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $aarGroup;
    /**
     * The retainDestInCallFwdHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retainDestInCallFwdHistory;
    /**
     * The forwardDestAllCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $forwardDestAllCalls;
    /**
     * The primaryCssForwardingAllCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $primaryCssForwardingAllCalls;
    /**
     * The secondaryCssForwardingAllCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $secondaryCssForwardingAllCalls;
    /**
     * The CssActivationPolicy
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $CssActivationPolicy;
    /**
     * The fwdDestExtCallsWhenNotRetrieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fwdDestExtCallsWhenNotRetrieved;
    /**
     * The cssFwdExtCallsWhenNotRetrieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $cssFwdExtCallsWhenNotRetrieved;
    /**
     * The fwdDestInternalCallsWhenNotRetrieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $fwdDestInternalCallsWhenNotRetrieved;
    /**
     * The cssFwdInternalCallsWhenNotRetrieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $cssFwdInternalCallsWhenNotRetrieved;
    /**
     * The parkMonitorReversionTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parkMonitorReversionTime;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $target;
    /**
     * The mlppCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $mlppCss;
    /**
     * The mlppNoAnsRingDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppNoAnsRingDuration;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The holdReversionRingDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $holdReversionRingDuration;
    /**
     * The holdReversionNotificationInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $holdReversionNotificationInterval;
    /**
     * The busyIntCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $busyIntCallsDestination;
    /**
     * The busyIntCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $busyIntCallsCss;
    /**
     * The busyExtCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $busyExtCallsDestination;
    /**
     * The busyExtCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $busyExtCallsCss;
    /**
     * The noAnsIntCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noAnsIntCallsDestination;
    /**
     * The noAnsIntCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $noAnsIntCallsCss;
    /**
     * The noAnsExtCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noAnsExtCallsDestination;
    /**
     * The noAnsExtCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $noAnsExtCallsCss;
    /**
     * The noCoverageIntCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noCoverageIntCallsDestination;
    /**
     * The noCoverageIntCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $noCoverageIntCallsCss;
    /**
     * The noCoverageExtCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noCoverageExtCallsDestination;
    /**
     * The noCoverageExtCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $noCoverageExtCallsCss;
    /**
     * The unregisteredIntCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unregisteredIntCallsDestination;
    /**
     * The unregisteredIntCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $unregisteredIntCallsCss;
    /**
     * The unregisteredExtCallsDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unregisteredExtCallsDestination;
    /**
     * The unregisteredExtCallsCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $unregisteredExtCallsCss;
    /**
     * The ctiFailureDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ctiFailureDestination;
    /**
     * The ctiFailureCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $ctiFailureCss;
    /**
     * The callControlAgentProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callControlAgentProfile;
    /**
     * The enterpriseAltNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var E164AltNum
     */
    public $e164AltNum;
    /**
     * The advertisedFailoverNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $advertisedFailoverNumber;
    /**
     * Constructor method for XUniversalLineTemplate
     * @uses XUniversalLineTemplate::setName()
     * @uses XUniversalLineTemplate::setBlfPresenceGroup()
     * @uses XUniversalLineTemplate::setPartyEntranceTone()
     * @uses XUniversalLineTemplate::setAutoAnswer()
     * @uses XUniversalLineTemplate::setUrgentPriority()
     * @uses XUniversalLineTemplate::setLineDescription()
     * @uses XUniversalLineTemplate::setRoutePartition()
     * @uses XUniversalLineTemplate::setVoiceMailProfile()
     * @uses XUniversalLineTemplate::setCallingSearchSpace()
     * @uses XUniversalLineTemplate::setAlertingName()
     * @uses XUniversalLineTemplate::setExtCallControlProfile()
     * @uses XUniversalLineTemplate::setCallPickupGroup()
     * @uses XUniversalLineTemplate::setRejectAnonymousCall()
     * @uses XUniversalLineTemplate::setUserHoldMohAudioSource()
     * @uses XUniversalLineTemplate::setNetworkHoldMohAudioSource()
     * @uses XUniversalLineTemplate::setAarDestinationMask()
     * @uses XUniversalLineTemplate::setAarGroup()
     * @uses XUniversalLineTemplate::setRetainDestInCallFwdHistory()
     * @uses XUniversalLineTemplate::setForwardDestAllCalls()
     * @uses XUniversalLineTemplate::setPrimaryCssForwardingAllCalls()
     * @uses XUniversalLineTemplate::setSecondaryCssForwardingAllCalls()
     * @uses XUniversalLineTemplate::setCssActivationPolicy()
     * @uses XUniversalLineTemplate::setFwdDestExtCallsWhenNotRetrieved()
     * @uses XUniversalLineTemplate::setCssFwdExtCallsWhenNotRetrieved()
     * @uses XUniversalLineTemplate::setFwdDestInternalCallsWhenNotRetrieved()
     * @uses XUniversalLineTemplate::setCssFwdInternalCallsWhenNotRetrieved()
     * @uses XUniversalLineTemplate::setParkMonitorReversionTime()
     * @uses XUniversalLineTemplate::setTarget()
     * @uses XUniversalLineTemplate::setMlppCss()
     * @uses XUniversalLineTemplate::setMlppNoAnsRingDuration()
     * @uses XUniversalLineTemplate::setConfidentialAccess()
     * @uses XUniversalLineTemplate::setHoldReversionRingDuration()
     * @uses XUniversalLineTemplate::setHoldReversionNotificationInterval()
     * @uses XUniversalLineTemplate::setBusyIntCallsDestination()
     * @uses XUniversalLineTemplate::setBusyIntCallsCss()
     * @uses XUniversalLineTemplate::setBusyExtCallsDestination()
     * @uses XUniversalLineTemplate::setBusyExtCallsCss()
     * @uses XUniversalLineTemplate::setNoAnsIntCallsDestination()
     * @uses XUniversalLineTemplate::setNoAnsIntCallsCss()
     * @uses XUniversalLineTemplate::setNoAnsExtCallsDestination()
     * @uses XUniversalLineTemplate::setNoAnsExtCallsCss()
     * @uses XUniversalLineTemplate::setNoCoverageIntCallsDestination()
     * @uses XUniversalLineTemplate::setNoCoverageIntCallsCss()
     * @uses XUniversalLineTemplate::setNoCoverageExtCallsDestination()
     * @uses XUniversalLineTemplate::setNoCoverageExtCallsCss()
     * @uses XUniversalLineTemplate::setUnregisteredIntCallsDestination()
     * @uses XUniversalLineTemplate::setUnregisteredIntCallsCss()
     * @uses XUniversalLineTemplate::setUnregisteredExtCallsDestination()
     * @uses XUniversalLineTemplate::setUnregisteredExtCallsCss()
     * @uses XUniversalLineTemplate::setCtiFailureDestination()
     * @uses XUniversalLineTemplate::setCtiFailureCss()
     * @uses XUniversalLineTemplate::setCallControlAgentProfile()
     * @uses XUniversalLineTemplate::setEnterpriseAltNum()
     * @uses XUniversalLineTemplate::setE164AltNum()
     * @uses XUniversalLineTemplate::setAdvertisedFailoverNumber()
     * @param string $name
     * @param XFkType $blfPresenceGroup
     * @param string $partyEntranceTone
     * @param string $autoAnswer
     * @param string $urgentPriority
     * @param string $lineDescription
     * @param XFkType $routePartition
     * @param XFkType $voiceMailProfile
     * @param XFkType $callingSearchSpace
     * @param string $alertingName
     * @param XFkType $extCallControlProfile
     * @param XFkType $callPickupGroup
     * @param string $rejectAnonymousCall
     * @param string $userHoldMohAudioSource
     * @param string $networkHoldMohAudioSource
     * @param string $aarDestinationMask
     * @param XFkType $aarGroup
     * @param string $retainDestInCallFwdHistory
     * @param string $forwardDestAllCalls
     * @param XFkType $primaryCssForwardingAllCalls
     * @param XFkType $secondaryCssForwardingAllCalls
     * @param string $cssActivationPolicy
     * @param string $fwdDestExtCallsWhenNotRetrieved
     * @param XFkType $cssFwdExtCallsWhenNotRetrieved
     * @param string $fwdDestInternalCallsWhenNotRetrieved
     * @param XFkType $cssFwdInternalCallsWhenNotRetrieved
     * @param string $parkMonitorReversionTime
     * @param string $target
     * @param XFkType $mlppCss
     * @param string $mlppNoAnsRingDuration
     * @param ConfidentialAccess $confidentialAccess
     * @param string $holdReversionRingDuration
     * @param string $holdReversionNotificationInterval
     * @param string $busyIntCallsDestination
     * @param XFkType $busyIntCallsCss
     * @param string $busyExtCallsDestination
     * @param XFkType $busyExtCallsCss
     * @param string $noAnsIntCallsDestination
     * @param XFkType $noAnsIntCallsCss
     * @param string $noAnsExtCallsDestination
     * @param XFkType $noAnsExtCallsCss
     * @param string $noCoverageIntCallsDestination
     * @param XFkType $noCoverageIntCallsCss
     * @param string $noCoverageExtCallsDestination
     * @param XFkType $noCoverageExtCallsCss
     * @param string $unregisteredIntCallsDestination
     * @param XFkType $unregisteredIntCallsCss
     * @param string $unregisteredExtCallsDestination
     * @param XFkType $unregisteredExtCallsCss
     * @param string $ctiFailureDestination
     * @param XFkType $ctiFailureCss
     * @param string $callControlAgentProfile
     * @param EnterpriseAltNum $enterpriseAltNum
     * @param E164AltNum $e164AltNum
     * @param string $advertisedFailoverNumber
     */
    public function __construct($name = null, XFkType $blfPresenceGroup = null, $partyEntranceTone = 'Default', $autoAnswer = 'Auto Answer Off', $urgentPriority = null, $lineDescription = null, XFkType $routePartition = null, XFkType $voiceMailProfile = null, XFkType $callingSearchSpace = null, $alertingName = null, XFkType $extCallControlProfile = null, XFkType $callPickupGroup = null, $rejectAnonymousCall = null, $userHoldMohAudioSource = null, $networkHoldMohAudioSource = null, $aarDestinationMask = null, XFkType $aarGroup = null, $retainDestInCallFwdHistory = null, $forwardDestAllCalls = null, XFkType $primaryCssForwardingAllCalls = null, XFkType $secondaryCssForwardingAllCalls = null, $cssActivationPolicy = 'Use System Default', $fwdDestExtCallsWhenNotRetrieved = null, XFkType $cssFwdExtCallsWhenNotRetrieved = null, $fwdDestInternalCallsWhenNotRetrieved = null, XFkType $cssFwdInternalCallsWhenNotRetrieved = null, $parkMonitorReversionTime = null, $target = null, XFkType $mlppCss = null, $mlppNoAnsRingDuration = null, ConfidentialAccess $confidentialAccess = null, $holdReversionRingDuration = null, $holdReversionNotificationInterval = null, $busyIntCallsDestination = null, XFkType $busyIntCallsCss = null, $busyExtCallsDestination = null, XFkType $busyExtCallsCss = null, $noAnsIntCallsDestination = null, XFkType $noAnsIntCallsCss = null, $noAnsExtCallsDestination = null, XFkType $noAnsExtCallsCss = null, $noCoverageIntCallsDestination = null, XFkType $noCoverageIntCallsCss = null, $noCoverageExtCallsDestination = null, XFkType $noCoverageExtCallsCss = null, $unregisteredIntCallsDestination = null, XFkType $unregisteredIntCallsCss = null, $unregisteredExtCallsDestination = null, XFkType $unregisteredExtCallsCss = null, $ctiFailureDestination = null, XFkType $ctiFailureCss = null, $callControlAgentProfile = null, EnterpriseAltNum $enterpriseAltNum = null, E164AltNum $e164AltNum = null, $advertisedFailoverNumber = null)
    {
        $this
            ->setName($name)
            ->setBlfPresenceGroup($blfPresenceGroup)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setAutoAnswer($autoAnswer)
            ->setUrgentPriority($urgentPriority)
            ->setLineDescription($lineDescription)
            ->setRoutePartition($routePartition)
            ->setVoiceMailProfile($voiceMailProfile)
            ->setCallingSearchSpace($callingSearchSpace)
            ->setAlertingName($alertingName)
            ->setExtCallControlProfile($extCallControlProfile)
            ->setCallPickupGroup($callPickupGroup)
            ->setRejectAnonymousCall($rejectAnonymousCall)
            ->setUserHoldMohAudioSource($userHoldMohAudioSource)
            ->setNetworkHoldMohAudioSource($networkHoldMohAudioSource)
            ->setAarDestinationMask($aarDestinationMask)
            ->setAarGroup($aarGroup)
            ->setRetainDestInCallFwdHistory($retainDestInCallFwdHistory)
            ->setForwardDestAllCalls($forwardDestAllCalls)
            ->setPrimaryCssForwardingAllCalls($primaryCssForwardingAllCalls)
            ->setSecondaryCssForwardingAllCalls($secondaryCssForwardingAllCalls)
            ->setCssActivationPolicy($cssActivationPolicy)
            ->setFwdDestExtCallsWhenNotRetrieved($fwdDestExtCallsWhenNotRetrieved)
            ->setCssFwdExtCallsWhenNotRetrieved($cssFwdExtCallsWhenNotRetrieved)
            ->setFwdDestInternalCallsWhenNotRetrieved($fwdDestInternalCallsWhenNotRetrieved)
            ->setCssFwdInternalCallsWhenNotRetrieved($cssFwdInternalCallsWhenNotRetrieved)
            ->setParkMonitorReversionTime($parkMonitorReversionTime)
            ->setTarget($target)
            ->setMlppCss($mlppCss)
            ->setMlppNoAnsRingDuration($mlppNoAnsRingDuration)
            ->setConfidentialAccess($confidentialAccess)
            ->setHoldReversionRingDuration($holdReversionRingDuration)
            ->setHoldReversionNotificationInterval($holdReversionNotificationInterval)
            ->setBusyIntCallsDestination($busyIntCallsDestination)
            ->setBusyIntCallsCss($busyIntCallsCss)
            ->setBusyExtCallsDestination($busyExtCallsDestination)
            ->setBusyExtCallsCss($busyExtCallsCss)
            ->setNoAnsIntCallsDestination($noAnsIntCallsDestination)
            ->setNoAnsIntCallsCss($noAnsIntCallsCss)
            ->setNoAnsExtCallsDestination($noAnsExtCallsDestination)
            ->setNoAnsExtCallsCss($noAnsExtCallsCss)
            ->setNoCoverageIntCallsDestination($noCoverageIntCallsDestination)
            ->setNoCoverageIntCallsCss($noCoverageIntCallsCss)
            ->setNoCoverageExtCallsDestination($noCoverageExtCallsDestination)
            ->setNoCoverageExtCallsCss($noCoverageExtCallsCss)
            ->setUnregisteredIntCallsDestination($unregisteredIntCallsDestination)
            ->setUnregisteredIntCallsCss($unregisteredIntCallsCss)
            ->setUnregisteredExtCallsDestination($unregisteredExtCallsDestination)
            ->setUnregisteredExtCallsCss($unregisteredExtCallsCss)
            ->setCtiFailureDestination($ctiFailureDestination)
            ->setCtiFailureCss($ctiFailureCss)
            ->setCallControlAgentProfile($callControlAgentProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setAdvertisedFailoverNumber($advertisedFailoverNumber);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XUniversalLineTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get blfPresenceGroup value
     * @return XFkType
     */
    public function getBlfPresenceGroup()
    {
        return $this->blfPresenceGroup;
    }
    /**
     * Set blfPresenceGroup value
     * @param XFkType $blfPresenceGroup
     * @return XUniversalLineTemplate
     */
    public function setBlfPresenceGroup(XFkType $blfPresenceGroup = null)
    {
        $this->blfPresenceGroup = $blfPresenceGroup;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return string
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partyEntranceTone
     * @return XUniversalLineTemplate
     */
    public function setPartyEntranceTone($partyEntranceTone = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($partyEntranceTone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $partyEntranceTone, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return string
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @uses XAutoAnswer::valueIsValid()
     * @uses XAutoAnswer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoAnswer
     * @return XUniversalLineTemplate
     */
    public function setAutoAnswer($autoAnswer = 'Auto Answer Off')
    {
        // validation for constraint: enumeration
        if (!XAutoAnswer::valueIsValid($autoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $autoAnswer, implode(', ', XAutoAnswer::getValidValues())), __LINE__);
        }
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get urgentPriority value
     * @return string|null
     */
    public function getUrgentPriority()
    {
        return $this->urgentPriority;
    }
    /**
     * Set urgentPriority value
     * @param string $urgentPriority
     * @return XUniversalLineTemplate
     */
    public function setUrgentPriority($urgentPriority = null)
    {
        // validation for constraint: pattern
        if (is_scalar($urgentPriority) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $urgentPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($urgentPriority, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($urgentPriority) && !is_string($urgentPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urgentPriority)), __LINE__);
        }
        $this->urgentPriority = $urgentPriority;
        return $this;
    }
    /**
     * Get lineDescription value
     * @return string|null
     */
    public function getLineDescription()
    {
        return $this->lineDescription;
    }
    /**
     * Set lineDescription value
     * @param string $lineDescription
     * @return XUniversalLineTemplate
     */
    public function setLineDescription($lineDescription = null)
    {
        // validation for constraint: string
        if (!is_null($lineDescription) && !is_string($lineDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineDescription)), __LINE__);
        }
        $this->lineDescription = $lineDescription;
        return $this;
    }
    /**
     * Get routePartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRoutePartition()
    {
        return isset($this->routePartition) ? $this->routePartition : null;
    }
    /**
     * Set routePartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $routePartition
     * @return XUniversalLineTemplate
     */
    public function setRoutePartition(XFkType $routePartition = null)
    {
        if (is_null($routePartition) || (is_array($routePartition) && empty($routePartition))) {
            unset($this->routePartition);
        } else {
            $this->routePartition = $routePartition;
        }
        return $this;
    }
    /**
     * Get voiceMailProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getVoiceMailProfile()
    {
        return isset($this->voiceMailProfile) ? $this->voiceMailProfile : null;
    }
    /**
     * Set voiceMailProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $voiceMailProfile
     * @return XUniversalLineTemplate
     */
    public function setVoiceMailProfile(XFkType $voiceMailProfile = null)
    {
        if (is_null($voiceMailProfile) || (is_array($voiceMailProfile) && empty($voiceMailProfile))) {
            unset($this->voiceMailProfile);
        } else {
            $this->voiceMailProfile = $voiceMailProfile;
        }
        return $this;
    }
    /**
     * Get callingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingSearchSpace()
    {
        return isset($this->callingSearchSpace) ? $this->callingSearchSpace : null;
    }
    /**
     * Set callingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingSearchSpace
     * @return XUniversalLineTemplate
     */
    public function setCallingSearchSpace(XFkType $callingSearchSpace = null)
    {
        if (is_null($callingSearchSpace) || (is_array($callingSearchSpace) && empty($callingSearchSpace))) {
            unset($this->callingSearchSpace);
        } else {
            $this->callingSearchSpace = $callingSearchSpace;
        }
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return XUniversalLineTemplate
     */
    public function setAlertingName($alertingName = null)
    {
        // validation for constraint: string
        if (!is_null($alertingName) && !is_string($alertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertingName)), __LINE__);
        }
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get extCallControlProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getExtCallControlProfile()
    {
        return isset($this->extCallControlProfile) ? $this->extCallControlProfile : null;
    }
    /**
     * Set extCallControlProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $extCallControlProfile
     * @return XUniversalLineTemplate
     */
    public function setExtCallControlProfile(XFkType $extCallControlProfile = null)
    {
        if (is_null($extCallControlProfile) || (is_array($extCallControlProfile) && empty($extCallControlProfile))) {
            unset($this->extCallControlProfile);
        } else {
            $this->extCallControlProfile = $extCallControlProfile;
        }
        return $this;
    }
    /**
     * Get callPickupGroup value
     * @return XFkType|null
     */
    public function getCallPickupGroup()
    {
        return $this->callPickupGroup;
    }
    /**
     * Set callPickupGroup value
     * @param XFkType $callPickupGroup
     * @return XUniversalLineTemplate
     */
    public function setCallPickupGroup(XFkType $callPickupGroup = null)
    {
        $this->callPickupGroup = $callPickupGroup;
        return $this;
    }
    /**
     * Get rejectAnonymousCall value
     * @return string|null
     */
    public function getRejectAnonymousCall()
    {
        return $this->rejectAnonymousCall;
    }
    /**
     * Set rejectAnonymousCall value
     * @param string $rejectAnonymousCall
     * @return XUniversalLineTemplate
     */
    public function setRejectAnonymousCall($rejectAnonymousCall = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rejectAnonymousCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rejectAnonymousCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rejectAnonymousCall, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rejectAnonymousCall) && !is_string($rejectAnonymousCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rejectAnonymousCall)), __LINE__);
        }
        $this->rejectAnonymousCall = $rejectAnonymousCall;
        return $this;
    }
    /**
     * Get userHoldMohAudioSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSource()
    {
        return isset($this->userHoldMohAudioSource) ? $this->userHoldMohAudioSource : null;
    }
    /**
     * Set userHoldMohAudioSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XMOHAudioSourceId::valueIsValid()
     * @uses XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSource
     * @return XUniversalLineTemplate
     */
    public function setUserHoldMohAudioSource($userHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!XMOHAudioSourceId::valueIsValid($userHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSource, implode(', ', XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSource) || (is_array($userHoldMohAudioSource) && empty($userHoldMohAudioSource))) {
            unset($this->userHoldMohAudioSource);
        } else {
            $this->userHoldMohAudioSource = $userHoldMohAudioSource;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSource()
    {
        return isset($this->networkHoldMohAudioSource) ? $this->networkHoldMohAudioSource : null;
    }
    /**
     * Set networkHoldMohAudioSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XMOHAudioSourceId::valueIsValid()
     * @uses XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSource
     * @return XUniversalLineTemplate
     */
    public function setNetworkHoldMohAudioSource($networkHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSource, implode(', ', XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($networkHoldMohAudioSource) || (is_array($networkHoldMohAudioSource) && empty($networkHoldMohAudioSource))) {
            unset($this->networkHoldMohAudioSource);
        } else {
            $this->networkHoldMohAudioSource = $networkHoldMohAudioSource;
        }
        return $this;
    }
    /**
     * Get aarDestinationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAarDestinationMask()
    {
        return isset($this->aarDestinationMask) ? $this->aarDestinationMask : null;
    }
    /**
     * Set aarDestinationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aarDestinationMask
     * @return XUniversalLineTemplate
     */
    public function setAarDestinationMask($aarDestinationMask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aarDestinationMask) && strlen($aarDestinationMask) > 128) || (is_array($aarDestinationMask) && count($aarDestinationMask) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($aarDestinationMask) ? strlen($aarDestinationMask) : count($aarDestinationMask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aarDestinationMask) && !is_string($aarDestinationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aarDestinationMask)), __LINE__);
        }
        if (is_null($aarDestinationMask) || (is_array($aarDestinationMask) && empty($aarDestinationMask))) {
            unset($this->aarDestinationMask);
        } else {
            $this->aarDestinationMask = $aarDestinationMask;
        }
        return $this;
    }
    /**
     * Get aarGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAarGroup()
    {
        return isset($this->aarGroup) ? $this->aarGroup : null;
    }
    /**
     * Set aarGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $aarGroup
     * @return XUniversalLineTemplate
     */
    public function setAarGroup(XFkType $aarGroup = null)
    {
        if (is_null($aarGroup) || (is_array($aarGroup) && empty($aarGroup))) {
            unset($this->aarGroup);
        } else {
            $this->aarGroup = $aarGroup;
        }
        return $this;
    }
    /**
     * Get retainDestInCallFwdHistory value
     * @return string|null
     */
    public function getRetainDestInCallFwdHistory()
    {
        return $this->retainDestInCallFwdHistory;
    }
    /**
     * Set retainDestInCallFwdHistory value
     * @param string $retainDestInCallFwdHistory
     * @return XUniversalLineTemplate
     */
    public function setRetainDestInCallFwdHistory($retainDestInCallFwdHistory = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retainDestInCallFwdHistory) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retainDestInCallFwdHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retainDestInCallFwdHistory, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retainDestInCallFwdHistory) && !is_string($retainDestInCallFwdHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retainDestInCallFwdHistory)), __LINE__);
        }
        $this->retainDestInCallFwdHistory = $retainDestInCallFwdHistory;
        return $this;
    }
    /**
     * Get forwardDestAllCalls value
     * @return string|null
     */
    public function getForwardDestAllCalls()
    {
        return $this->forwardDestAllCalls;
    }
    /**
     * Set forwardDestAllCalls value
     * @param string $forwardDestAllCalls
     * @return XUniversalLineTemplate
     */
    public function setForwardDestAllCalls($forwardDestAllCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($forwardDestAllCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $forwardDestAllCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($forwardDestAllCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($forwardDestAllCalls) && !is_string($forwardDestAllCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwardDestAllCalls)), __LINE__);
        }
        $this->forwardDestAllCalls = $forwardDestAllCalls;
        return $this;
    }
    /**
     * Get primaryCssForwardingAllCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getPrimaryCssForwardingAllCalls()
    {
        return isset($this->primaryCssForwardingAllCalls) ? $this->primaryCssForwardingAllCalls : null;
    }
    /**
     * Set primaryCssForwardingAllCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $primaryCssForwardingAllCalls
     * @return XUniversalLineTemplate
     */
    public function setPrimaryCssForwardingAllCalls(XFkType $primaryCssForwardingAllCalls = null)
    {
        if (is_null($primaryCssForwardingAllCalls) || (is_array($primaryCssForwardingAllCalls) && empty($primaryCssForwardingAllCalls))) {
            unset($this->primaryCssForwardingAllCalls);
        } else {
            $this->primaryCssForwardingAllCalls = $primaryCssForwardingAllCalls;
        }
        return $this;
    }
    /**
     * Get secondaryCssForwardingAllCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSecondaryCssForwardingAllCalls()
    {
        return isset($this->secondaryCssForwardingAllCalls) ? $this->secondaryCssForwardingAllCalls : null;
    }
    /**
     * Set secondaryCssForwardingAllCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $secondaryCssForwardingAllCalls
     * @return XUniversalLineTemplate
     */
    public function setSecondaryCssForwardingAllCalls(XFkType $secondaryCssForwardingAllCalls = null)
    {
        if (is_null($secondaryCssForwardingAllCalls) || (is_array($secondaryCssForwardingAllCalls) && empty($secondaryCssForwardingAllCalls))) {
            unset($this->secondaryCssForwardingAllCalls);
        } else {
            $this->secondaryCssForwardingAllCalls = $secondaryCssForwardingAllCalls;
        }
        return $this;
    }
    /**
     * Get CssActivationPolicy value
     * @return string|null
     */
    public function getCssActivationPolicy()
    {
        return $this->CssActivationPolicy;
    }
    /**
     * Set CssActivationPolicy value
     * @uses XCFACSSActivationPolicy::valueIsValid()
     * @uses XCFACSSActivationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cssActivationPolicy
     * @return XUniversalLineTemplate
     */
    public function setCssActivationPolicy($cssActivationPolicy = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!XCFACSSActivationPolicy::valueIsValid($cssActivationPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cssActivationPolicy, implode(', ', XCFACSSActivationPolicy::getValidValues())), __LINE__);
        }
        $this->CssActivationPolicy = $cssActivationPolicy;
        return $this;
    }
    /**
     * Get fwdDestExtCallsWhenNotRetrieved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFwdDestExtCallsWhenNotRetrieved()
    {
        return isset($this->fwdDestExtCallsWhenNotRetrieved) ? $this->fwdDestExtCallsWhenNotRetrieved : null;
    }
    /**
     * Set fwdDestExtCallsWhenNotRetrieved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fwdDestExtCallsWhenNotRetrieved
     * @return XUniversalLineTemplate
     */
    public function setFwdDestExtCallsWhenNotRetrieved($fwdDestExtCallsWhenNotRetrieved = null)
    {
        // validation for constraint: string
        if (!is_null($fwdDestExtCallsWhenNotRetrieved) && !is_string($fwdDestExtCallsWhenNotRetrieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fwdDestExtCallsWhenNotRetrieved)), __LINE__);
        }
        if (is_null($fwdDestExtCallsWhenNotRetrieved) || (is_array($fwdDestExtCallsWhenNotRetrieved) && empty($fwdDestExtCallsWhenNotRetrieved))) {
            unset($this->fwdDestExtCallsWhenNotRetrieved);
        } else {
            $this->fwdDestExtCallsWhenNotRetrieved = $fwdDestExtCallsWhenNotRetrieved;
        }
        return $this;
    }
    /**
     * Get cssFwdExtCallsWhenNotRetrieved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCssFwdExtCallsWhenNotRetrieved()
    {
        return isset($this->cssFwdExtCallsWhenNotRetrieved) ? $this->cssFwdExtCallsWhenNotRetrieved : null;
    }
    /**
     * Set cssFwdExtCallsWhenNotRetrieved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $cssFwdExtCallsWhenNotRetrieved
     * @return XUniversalLineTemplate
     */
    public function setCssFwdExtCallsWhenNotRetrieved(XFkType $cssFwdExtCallsWhenNotRetrieved = null)
    {
        if (is_null($cssFwdExtCallsWhenNotRetrieved) || (is_array($cssFwdExtCallsWhenNotRetrieved) && empty($cssFwdExtCallsWhenNotRetrieved))) {
            unset($this->cssFwdExtCallsWhenNotRetrieved);
        } else {
            $this->cssFwdExtCallsWhenNotRetrieved = $cssFwdExtCallsWhenNotRetrieved;
        }
        return $this;
    }
    /**
     * Get fwdDestInternalCallsWhenNotRetrieved value
     * @return string|null
     */
    public function getFwdDestInternalCallsWhenNotRetrieved()
    {
        return $this->fwdDestInternalCallsWhenNotRetrieved;
    }
    /**
     * Set fwdDestInternalCallsWhenNotRetrieved value
     * @param string $fwdDestInternalCallsWhenNotRetrieved
     * @return XUniversalLineTemplate
     */
    public function setFwdDestInternalCallsWhenNotRetrieved($fwdDestInternalCallsWhenNotRetrieved = null)
    {
        // validation for constraint: pattern
        if (is_scalar($fwdDestInternalCallsWhenNotRetrieved) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $fwdDestInternalCallsWhenNotRetrieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($fwdDestInternalCallsWhenNotRetrieved, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fwdDestInternalCallsWhenNotRetrieved) && !is_string($fwdDestInternalCallsWhenNotRetrieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fwdDestInternalCallsWhenNotRetrieved)), __LINE__);
        }
        $this->fwdDestInternalCallsWhenNotRetrieved = $fwdDestInternalCallsWhenNotRetrieved;
        return $this;
    }
    /**
     * Get cssFwdInternalCallsWhenNotRetrieved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCssFwdInternalCallsWhenNotRetrieved()
    {
        return isset($this->cssFwdInternalCallsWhenNotRetrieved) ? $this->cssFwdInternalCallsWhenNotRetrieved : null;
    }
    /**
     * Set cssFwdInternalCallsWhenNotRetrieved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $cssFwdInternalCallsWhenNotRetrieved
     * @return XUniversalLineTemplate
     */
    public function setCssFwdInternalCallsWhenNotRetrieved(XFkType $cssFwdInternalCallsWhenNotRetrieved = null)
    {
        if (is_null($cssFwdInternalCallsWhenNotRetrieved) || (is_array($cssFwdInternalCallsWhenNotRetrieved) && empty($cssFwdInternalCallsWhenNotRetrieved))) {
            unset($this->cssFwdInternalCallsWhenNotRetrieved);
        } else {
            $this->cssFwdInternalCallsWhenNotRetrieved = $cssFwdInternalCallsWhenNotRetrieved;
        }
        return $this;
    }
    /**
     * Get parkMonitorReversionTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParkMonitorReversionTime()
    {
        return isset($this->parkMonitorReversionTime) ? $this->parkMonitorReversionTime : null;
    }
    /**
     * Set parkMonitorReversionTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parkMonitorReversionTime
     * @return XUniversalLineTemplate
     */
    public function setParkMonitorReversionTime($parkMonitorReversionTime = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($parkMonitorReversionTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $parkMonitorReversionTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($parkMonitorReversionTime) || (is_array($parkMonitorReversionTime) && empty($parkMonitorReversionTime))) {
            unset($this->parkMonitorReversionTime);
        } else {
            $this->parkMonitorReversionTime = $parkMonitorReversionTime;
        }
        return $this;
    }
    /**
     * Get target value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTarget()
    {
        return isset($this->target) ? $this->target : null;
    }
    /**
     * Set target value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $target
     * @return XUniversalLineTemplate
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        if (is_null($target) || (is_array($target) && empty($target))) {
            unset($this->target);
        } else {
            $this->target = $target;
        }
        return $this;
    }
    /**
     * Get mlppCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMlppCss()
    {
        return isset($this->mlppCss) ? $this->mlppCss : null;
    }
    /**
     * Set mlppCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $mlppCss
     * @return XUniversalLineTemplate
     */
    public function setMlppCss(XFkType $mlppCss = null)
    {
        if (is_null($mlppCss) || (is_array($mlppCss) && empty($mlppCss))) {
            unset($this->mlppCss);
        } else {
            $this->mlppCss = $mlppCss;
        }
        return $this;
    }
    /**
     * Get mlppNoAnsRingDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppNoAnsRingDuration()
    {
        return isset($this->mlppNoAnsRingDuration) ? $this->mlppNoAnsRingDuration : null;
    }
    /**
     * Set mlppNoAnsRingDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppNoAnsRingDuration
     * @return XUniversalLineTemplate
     */
    public function setMlppNoAnsRingDuration($mlppNoAnsRingDuration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($mlppNoAnsRingDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppNoAnsRingDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($mlppNoAnsRingDuration) || (is_array($mlppNoAnsRingDuration) && empty($mlppNoAnsRingDuration))) {
            unset($this->mlppNoAnsRingDuration);
        } else {
            $this->mlppNoAnsRingDuration = $mlppNoAnsRingDuration;
        }
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return XUniversalLineTemplate
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get holdReversionRingDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoldReversionRingDuration()
    {
        return isset($this->holdReversionRingDuration) ? $this->holdReversionRingDuration : null;
    }
    /**
     * Set holdReversionRingDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $holdReversionRingDuration
     * @return XUniversalLineTemplate
     */
    public function setHoldReversionRingDuration($holdReversionRingDuration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($holdReversionRingDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $holdReversionRingDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($holdReversionRingDuration) || (is_array($holdReversionRingDuration) && empty($holdReversionRingDuration))) {
            unset($this->holdReversionRingDuration);
        } else {
            $this->holdReversionRingDuration = $holdReversionRingDuration;
        }
        return $this;
    }
    /**
     * Get holdReversionNotificationInterval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoldReversionNotificationInterval()
    {
        return isset($this->holdReversionNotificationInterval) ? $this->holdReversionNotificationInterval : null;
    }
    /**
     * Set holdReversionNotificationInterval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $holdReversionNotificationInterval
     * @return XUniversalLineTemplate
     */
    public function setHoldReversionNotificationInterval($holdReversionNotificationInterval = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($holdReversionNotificationInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $holdReversionNotificationInterval, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($holdReversionNotificationInterval) || (is_array($holdReversionNotificationInterval) && empty($holdReversionNotificationInterval))) {
            unset($this->holdReversionNotificationInterval);
        } else {
            $this->holdReversionNotificationInterval = $holdReversionNotificationInterval;
        }
        return $this;
    }
    /**
     * Get busyIntCallsDestination value
     * @return string|null
     */
    public function getBusyIntCallsDestination()
    {
        return $this->busyIntCallsDestination;
    }
    /**
     * Set busyIntCallsDestination value
     * @param string $busyIntCallsDestination
     * @return XUniversalLineTemplate
     */
    public function setBusyIntCallsDestination($busyIntCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($busyIntCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $busyIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($busyIntCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($busyIntCallsDestination) && !is_string($busyIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busyIntCallsDestination)), __LINE__);
        }
        $this->busyIntCallsDestination = $busyIntCallsDestination;
        return $this;
    }
    /**
     * Get busyIntCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getBusyIntCallsCss()
    {
        return isset($this->busyIntCallsCss) ? $this->busyIntCallsCss : null;
    }
    /**
     * Set busyIntCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $busyIntCallsCss
     * @return XUniversalLineTemplate
     */
    public function setBusyIntCallsCss(XFkType $busyIntCallsCss = null)
    {
        if (is_null($busyIntCallsCss) || (is_array($busyIntCallsCss) && empty($busyIntCallsCss))) {
            unset($this->busyIntCallsCss);
        } else {
            $this->busyIntCallsCss = $busyIntCallsCss;
        }
        return $this;
    }
    /**
     * Get busyExtCallsDestination value
     * @return string|null
     */
    public function getBusyExtCallsDestination()
    {
        return $this->busyExtCallsDestination;
    }
    /**
     * Set busyExtCallsDestination value
     * @param string $busyExtCallsDestination
     * @return XUniversalLineTemplate
     */
    public function setBusyExtCallsDestination($busyExtCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($busyExtCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $busyExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($busyExtCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($busyExtCallsDestination) && !is_string($busyExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busyExtCallsDestination)), __LINE__);
        }
        $this->busyExtCallsDestination = $busyExtCallsDestination;
        return $this;
    }
    /**
     * Get busyExtCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getBusyExtCallsCss()
    {
        return isset($this->busyExtCallsCss) ? $this->busyExtCallsCss : null;
    }
    /**
     * Set busyExtCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $busyExtCallsCss
     * @return XUniversalLineTemplate
     */
    public function setBusyExtCallsCss(XFkType $busyExtCallsCss = null)
    {
        if (is_null($busyExtCallsCss) || (is_array($busyExtCallsCss) && empty($busyExtCallsCss))) {
            unset($this->busyExtCallsCss);
        } else {
            $this->busyExtCallsCss = $busyExtCallsCss;
        }
        return $this;
    }
    /**
     * Get noAnsIntCallsDestination value
     * @return string|null
     */
    public function getNoAnsIntCallsDestination()
    {
        return $this->noAnsIntCallsDestination;
    }
    /**
     * Set noAnsIntCallsDestination value
     * @param string $noAnsIntCallsDestination
     * @return XUniversalLineTemplate
     */
    public function setNoAnsIntCallsDestination($noAnsIntCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($noAnsIntCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $noAnsIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($noAnsIntCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noAnsIntCallsDestination) && !is_string($noAnsIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noAnsIntCallsDestination)), __LINE__);
        }
        $this->noAnsIntCallsDestination = $noAnsIntCallsDestination;
        return $this;
    }
    /**
     * Get noAnsIntCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNoAnsIntCallsCss()
    {
        return isset($this->noAnsIntCallsCss) ? $this->noAnsIntCallsCss : null;
    }
    /**
     * Set noAnsIntCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $noAnsIntCallsCss
     * @return XUniversalLineTemplate
     */
    public function setNoAnsIntCallsCss(XFkType $noAnsIntCallsCss = null)
    {
        if (is_null($noAnsIntCallsCss) || (is_array($noAnsIntCallsCss) && empty($noAnsIntCallsCss))) {
            unset($this->noAnsIntCallsCss);
        } else {
            $this->noAnsIntCallsCss = $noAnsIntCallsCss;
        }
        return $this;
    }
    /**
     * Get noAnsExtCallsDestination value
     * @return string|null
     */
    public function getNoAnsExtCallsDestination()
    {
        return $this->noAnsExtCallsDestination;
    }
    /**
     * Set noAnsExtCallsDestination value
     * @param string $noAnsExtCallsDestination
     * @return XUniversalLineTemplate
     */
    public function setNoAnsExtCallsDestination($noAnsExtCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($noAnsExtCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $noAnsExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($noAnsExtCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noAnsExtCallsDestination) && !is_string($noAnsExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noAnsExtCallsDestination)), __LINE__);
        }
        $this->noAnsExtCallsDestination = $noAnsExtCallsDestination;
        return $this;
    }
    /**
     * Get noAnsExtCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNoAnsExtCallsCss()
    {
        return isset($this->noAnsExtCallsCss) ? $this->noAnsExtCallsCss : null;
    }
    /**
     * Set noAnsExtCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $noAnsExtCallsCss
     * @return XUniversalLineTemplate
     */
    public function setNoAnsExtCallsCss(XFkType $noAnsExtCallsCss = null)
    {
        if (is_null($noAnsExtCallsCss) || (is_array($noAnsExtCallsCss) && empty($noAnsExtCallsCss))) {
            unset($this->noAnsExtCallsCss);
        } else {
            $this->noAnsExtCallsCss = $noAnsExtCallsCss;
        }
        return $this;
    }
    /**
     * Get noCoverageIntCallsDestination value
     * @return string|null
     */
    public function getNoCoverageIntCallsDestination()
    {
        return $this->noCoverageIntCallsDestination;
    }
    /**
     * Set noCoverageIntCallsDestination value
     * @param string $noCoverageIntCallsDestination
     * @return XUniversalLineTemplate
     */
    public function setNoCoverageIntCallsDestination($noCoverageIntCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($noCoverageIntCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $noCoverageIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($noCoverageIntCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noCoverageIntCallsDestination) && !is_string($noCoverageIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noCoverageIntCallsDestination)), __LINE__);
        }
        $this->noCoverageIntCallsDestination = $noCoverageIntCallsDestination;
        return $this;
    }
    /**
     * Get noCoverageIntCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNoCoverageIntCallsCss()
    {
        return isset($this->noCoverageIntCallsCss) ? $this->noCoverageIntCallsCss : null;
    }
    /**
     * Set noCoverageIntCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $noCoverageIntCallsCss
     * @return XUniversalLineTemplate
     */
    public function setNoCoverageIntCallsCss(XFkType $noCoverageIntCallsCss = null)
    {
        if (is_null($noCoverageIntCallsCss) || (is_array($noCoverageIntCallsCss) && empty($noCoverageIntCallsCss))) {
            unset($this->noCoverageIntCallsCss);
        } else {
            $this->noCoverageIntCallsCss = $noCoverageIntCallsCss;
        }
        return $this;
    }
    /**
     * Get noCoverageExtCallsDestination value
     * @return string|null
     */
    public function getNoCoverageExtCallsDestination()
    {
        return $this->noCoverageExtCallsDestination;
    }
    /**
     * Set noCoverageExtCallsDestination value
     * @param string $noCoverageExtCallsDestination
     * @return XUniversalLineTemplate
     */
    public function setNoCoverageExtCallsDestination($noCoverageExtCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($noCoverageExtCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $noCoverageExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($noCoverageExtCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noCoverageExtCallsDestination) && !is_string($noCoverageExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noCoverageExtCallsDestination)), __LINE__);
        }
        $this->noCoverageExtCallsDestination = $noCoverageExtCallsDestination;
        return $this;
    }
    /**
     * Get noCoverageExtCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNoCoverageExtCallsCss()
    {
        return isset($this->noCoverageExtCallsCss) ? $this->noCoverageExtCallsCss : null;
    }
    /**
     * Set noCoverageExtCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $noCoverageExtCallsCss
     * @return XUniversalLineTemplate
     */
    public function setNoCoverageExtCallsCss(XFkType $noCoverageExtCallsCss = null)
    {
        if (is_null($noCoverageExtCallsCss) || (is_array($noCoverageExtCallsCss) && empty($noCoverageExtCallsCss))) {
            unset($this->noCoverageExtCallsCss);
        } else {
            $this->noCoverageExtCallsCss = $noCoverageExtCallsCss;
        }
        return $this;
    }
    /**
     * Get unregisteredIntCallsDestination value
     * @return string|null
     */
    public function getUnregisteredIntCallsDestination()
    {
        return $this->unregisteredIntCallsDestination;
    }
    /**
     * Set unregisteredIntCallsDestination value
     * @param string $unregisteredIntCallsDestination
     * @return XUniversalLineTemplate
     */
    public function setUnregisteredIntCallsDestination($unregisteredIntCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unregisteredIntCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unregisteredIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unregisteredIntCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unregisteredIntCallsDestination) && !is_string($unregisteredIntCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unregisteredIntCallsDestination)), __LINE__);
        }
        $this->unregisteredIntCallsDestination = $unregisteredIntCallsDestination;
        return $this;
    }
    /**
     * Get unregisteredIntCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getUnregisteredIntCallsCss()
    {
        return isset($this->unregisteredIntCallsCss) ? $this->unregisteredIntCallsCss : null;
    }
    /**
     * Set unregisteredIntCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $unregisteredIntCallsCss
     * @return XUniversalLineTemplate
     */
    public function setUnregisteredIntCallsCss(XFkType $unregisteredIntCallsCss = null)
    {
        if (is_null($unregisteredIntCallsCss) || (is_array($unregisteredIntCallsCss) && empty($unregisteredIntCallsCss))) {
            unset($this->unregisteredIntCallsCss);
        } else {
            $this->unregisteredIntCallsCss = $unregisteredIntCallsCss;
        }
        return $this;
    }
    /**
     * Get unregisteredExtCallsDestination value
     * @return string|null
     */
    public function getUnregisteredExtCallsDestination()
    {
        return $this->unregisteredExtCallsDestination;
    }
    /**
     * Set unregisteredExtCallsDestination value
     * @param string $unregisteredExtCallsDestination
     * @return XUniversalLineTemplate
     */
    public function setUnregisteredExtCallsDestination($unregisteredExtCallsDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unregisteredExtCallsDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unregisteredExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unregisteredExtCallsDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unregisteredExtCallsDestination) && !is_string($unregisteredExtCallsDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unregisteredExtCallsDestination)), __LINE__);
        }
        $this->unregisteredExtCallsDestination = $unregisteredExtCallsDestination;
        return $this;
    }
    /**
     * Get unregisteredExtCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getUnregisteredExtCallsCss()
    {
        return isset($this->unregisteredExtCallsCss) ? $this->unregisteredExtCallsCss : null;
    }
    /**
     * Set unregisteredExtCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $unregisteredExtCallsCss
     * @return XUniversalLineTemplate
     */
    public function setUnregisteredExtCallsCss(XFkType $unregisteredExtCallsCss = null)
    {
        if (is_null($unregisteredExtCallsCss) || (is_array($unregisteredExtCallsCss) && empty($unregisteredExtCallsCss))) {
            unset($this->unregisteredExtCallsCss);
        } else {
            $this->unregisteredExtCallsCss = $unregisteredExtCallsCss;
        }
        return $this;
    }
    /**
     * Get ctiFailureDestination value
     * @return string|null
     */
    public function getCtiFailureDestination()
    {
        return $this->ctiFailureDestination;
    }
    /**
     * Set ctiFailureDestination value
     * @param string $ctiFailureDestination
     * @return XUniversalLineTemplate
     */
    public function setCtiFailureDestination($ctiFailureDestination = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ctiFailureDestination) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ctiFailureDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ctiFailureDestination, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ctiFailureDestination) && !is_string($ctiFailureDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ctiFailureDestination)), __LINE__);
        }
        $this->ctiFailureDestination = $ctiFailureDestination;
        return $this;
    }
    /**
     * Get ctiFailureCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCtiFailureCss()
    {
        return isset($this->ctiFailureCss) ? $this->ctiFailureCss : null;
    }
    /**
     * Set ctiFailureCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $ctiFailureCss
     * @return XUniversalLineTemplate
     */
    public function setCtiFailureCss(XFkType $ctiFailureCss = null)
    {
        if (is_null($ctiFailureCss) || (is_array($ctiFailureCss) && empty($ctiFailureCss))) {
            unset($this->ctiFailureCss);
        } else {
            $this->ctiFailureCss = $ctiFailureCss;
        }
        return $this;
    }
    /**
     * Get callControlAgentProfile value
     * @return string|null
     */
    public function getCallControlAgentProfile()
    {
        return $this->callControlAgentProfile;
    }
    /**
     * Set callControlAgentProfile value
     * @param string $callControlAgentProfile
     * @return XUniversalLineTemplate
     */
    public function setCallControlAgentProfile($callControlAgentProfile = null)
    {
        // validation for constraint: string
        if (!is_null($callControlAgentProfile) && !is_string($callControlAgentProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callControlAgentProfile)), __LINE__);
        }
        $this->callControlAgentProfile = $callControlAgentProfile;
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param EnterpriseAltNum $enterpriseAltNum
     * @return XUniversalLineTemplate
     */
    public function setEnterpriseAltNum(EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param E164AltNum $e164AltNum
     * @return XUniversalLineTemplate
     */
    public function setE164AltNum(E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get advertisedFailoverNumber value
     * @return string|null
     */
    public function getAdvertisedFailoverNumber()
    {
        return $this->advertisedFailoverNumber;
    }
    /**
     * Set advertisedFailoverNumber value
     * @param string $advertisedFailoverNumber
     * @return XUniversalLineTemplate
     */
    public function setAdvertisedFailoverNumber($advertisedFailoverNumber = null)
    {
        // validation for constraint: string
        if (!is_null($advertisedFailoverNumber) && !is_string($advertisedFailoverNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advertisedFailoverNumber)), __LINE__);
        }
        $this->advertisedFailoverNumber = $advertisedFailoverNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XUniversalLineTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
