<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipTrunkDestination StructType
 * @subpackage Structs
 */
class XSipTrunkDestination extends AbstractStructBase
{
    /**
     * The sortOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sortOrder;
    /**
     * The addressIpv4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $addressIpv4;
    /**
     * The addressIpv6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $addressIpv6;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * Constructor method for XSipTrunkDestination
     * @uses XSipTrunkDestination::setSortOrder()
     * @uses XSipTrunkDestination::setAddressIpv4()
     * @uses XSipTrunkDestination::setAddressIpv6()
     * @uses XSipTrunkDestination::setPort()
     * @param string $sortOrder
     * @param string $addressIpv4
     * @param string $addressIpv6
     * @param string $port
     */
    public function __construct($sortOrder = null, $addressIpv4 = null, $addressIpv6 = null, $port = '5060')
    {
        $this
            ->setSortOrder($sortOrder)
            ->setAddressIpv4($addressIpv4)
            ->setAddressIpv6($addressIpv6)
            ->setPort($port);
    }
    /**
     * Get sortOrder value
     * @return string
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return XSipTrunkDestination
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortOrder, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get addressIpv4 value
     * @return string|null
     */
    public function getAddressIpv4()
    {
        return $this->addressIpv4;
    }
    /**
     * Set addressIpv4 value
     * @param string $addressIpv4
     * @return XSipTrunkDestination
     */
    public function setAddressIpv4($addressIpv4 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressIpv4) && strlen($addressIpv4) > 255) || (is_array($addressIpv4) && count($addressIpv4) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($addressIpv4) ? strlen($addressIpv4) : count($addressIpv4)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressIpv4) && !is_string($addressIpv4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressIpv4)), __LINE__);
        }
        $this->addressIpv4 = $addressIpv4;
        return $this;
    }
    /**
     * Get addressIpv6 value
     * @return string|null
     */
    public function getAddressIpv6()
    {
        return $this->addressIpv6;
    }
    /**
     * Set addressIpv6 value
     * @param string $addressIpv6
     * @return XSipTrunkDestination
     */
    public function setAddressIpv6($addressIpv6 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressIpv6) && strlen($addressIpv6) > 255) || (is_array($addressIpv6) && count($addressIpv6) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($addressIpv6) ? strlen($addressIpv6) : count($addressIpv6)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressIpv6) && !is_string($addressIpv6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressIpv6)), __LINE__);
        }
        $this->addressIpv6 = $addressIpv6;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return XSipTrunkDestination
     */
    public function setPort($port = '5060')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XSipTrunkDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
