<?php
/**
 * This class stands for XSipPrivacy EnumType
 * @subpackage Enumerations
 */
class XSipPrivacy
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'ID'
     * @return string 'ID'
     */
    const VALUE_ID = 'ID';
    /**
     * Constant for value 'ID Critical'
     * @return string 'ID Critical'
     */
    const VALUE_ID_CRITICAL = 'ID Critical';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_NONE
     * @uses self::VALUE_ID
     * @uses self::VALUE_ID_CRITICAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_NONE,
            self::VALUE_ID,
            self::VALUE_ID_CRITICAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
