<?php
/**
 * This class stands for XServiceGrouping EnumType
 * @subpackage Enumerations
 */
class XServiceGrouping
{
    /**
     * Constant for value 'CM Services'
     * @return string 'CM Services'
     */
    const VALUE_CM_SERVICES = 'CM Services';
    /**
     * Constant for value 'CTI Services'
     * @return string 'CTI Services'
     */
    const VALUE_CTI_SERVICES = 'CTI Services';
    /**
     * Constant for value 'CDR Services'
     * @return string 'CDR Services'
     */
    const VALUE_CDR_SERVICES = 'CDR Services';
    /**
     * Constant for value 'Database and Admin Services'
     * @return string 'Database and Admin Services'
     */
    const VALUE_DATABASE_AND_ADMIN_SERVICES = 'Database and Admin Services';
    /**
     * Constant for value 'Performance and Monitoring Services'
     * @return string 'Performance and Monitoring Services'
     */
    const VALUE_PERFORMANCE_AND_MONITORING_SERVICES = 'Performance and Monitoring Services';
    /**
     * Constant for value 'Security Services'
     * @return string 'Security Services'
     */
    const VALUE_SECURITY_SERVICES = 'Security Services';
    /**
     * Constant for value 'Directory Services'
     * @return string 'Directory Services'
     */
    const VALUE_DIRECTORY_SERVICES = 'Directory Services';
    /**
     * Constant for value 'Backup and Restore Services'
     * @return string 'Backup and Restore Services'
     */
    const VALUE_BACKUP_AND_RESTORE_SERVICES = 'Backup and Restore Services';
    /**
     * Constant for value 'System Services'
     * @return string 'System Services'
     */
    const VALUE_SYSTEM_SERVICES = 'System Services';
    /**
     * Constant for value 'Soap Services'
     * @return string 'Soap Services'
     */
    const VALUE_SOAP_SERVICES = 'Soap Services';
    /**
     * Constant for value 'Voice Quality Reporter Services'
     * @return string 'Voice Quality Reporter Services'
     */
    const VALUE_VOICE_QUALITY_REPORTER_SERVICES = 'Voice Quality Reporter Services';
    /**
     * Constant for value 'Platform Services'
     * @return string 'Platform Services'
     */
    const VALUE_PLATFORM_SERVICES = 'Platform Services';
    /**
     * Constant for value 'IM and Presence Services'
     * @return string 'IM and Presence Services'
     */
    const VALUE_IM_AND_PRESENCE_SERVICES = 'IM and Presence Services';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CM_SERVICES
     * @uses self::VALUE_CTI_SERVICES
     * @uses self::VALUE_CDR_SERVICES
     * @uses self::VALUE_DATABASE_AND_ADMIN_SERVICES
     * @uses self::VALUE_PERFORMANCE_AND_MONITORING_SERVICES
     * @uses self::VALUE_SECURITY_SERVICES
     * @uses self::VALUE_DIRECTORY_SERVICES
     * @uses self::VALUE_BACKUP_AND_RESTORE_SERVICES
     * @uses self::VALUE_SYSTEM_SERVICES
     * @uses self::VALUE_SOAP_SERVICES
     * @uses self::VALUE_VOICE_QUALITY_REPORTER_SERVICES
     * @uses self::VALUE_PLATFORM_SERVICES
     * @uses self::VALUE_IM_AND_PRESENCE_SERVICES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CM_SERVICES,
            self::VALUE_CTI_SERVICES,
            self::VALUE_CDR_SERVICES,
            self::VALUE_DATABASE_AND_ADMIN_SERVICES,
            self::VALUE_PERFORMANCE_AND_MONITORING_SERVICES,
            self::VALUE_SECURITY_SERVICES,
            self::VALUE_DIRECTORY_SERVICES,
            self::VALUE_BACKUP_AND_RESTORE_SERVICES,
            self::VALUE_SYSTEM_SERVICES,
            self::VALUE_SOAP_SERVICES,
            self::VALUE_VOICE_QUALITY_REPORTER_SERVICES,
            self::VALUE_PLATFORM_SERVICES,
            self::VALUE_IM_AND_PRESENCE_SERVICES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
