<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSafForwarder StructType
 * @subpackage Structs
 */
class XSafForwarder extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The clientLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $clientLabel;
    /**
     * The safSecurityProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $safSecurityProfile;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $ipAddress;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - default: 5050
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The enableTcpKeepAlive
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTcpKeepAlive;
    /**
     * The safReconnectInterval
     * Meta informations extracted from the WSDL
     * - default: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safReconnectInterval;
    /**
     * The safNotificationsWindowSize
     * Meta informations extracted from the WSDL
     * - default: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safNotificationsWindowSize;
    /**
     * The associatedCucms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AssociatedCucms
     */
    public $associatedCucms;
    /**
     * Constructor method for XSafForwarder
     * @uses XSafForwarder::setName()
     * @uses XSafForwarder::setClientLabel()
     * @uses XSafForwarder::setSafSecurityProfile()
     * @uses XSafForwarder::setIpAddress()
     * @uses XSafForwarder::setDescription()
     * @uses XSafForwarder::setPort()
     * @uses XSafForwarder::setEnableTcpKeepAlive()
     * @uses XSafForwarder::setSafReconnectInterval()
     * @uses XSafForwarder::setSafNotificationsWindowSize()
     * @uses XSafForwarder::setAssociatedCucms()
     * @param string $name
     * @param string $clientLabel
     * @param XFkType $safSecurityProfile
     * @param string $ipAddress
     * @param string $description
     * @param string $port
     * @param string $enableTcpKeepAlive
     * @param string $safReconnectInterval
     * @param string $safNotificationsWindowSize
     * @param AssociatedCucms $associatedCucms
     */
    public function __construct($name = null, $clientLabel = null, XFkType $safSecurityProfile = null, $ipAddress = null, $description = null, $port = '5050', $enableTcpKeepAlive = true, $safReconnectInterval = '20', $safNotificationsWindowSize = '7', AssociatedCucms $associatedCucms = null)
    {
        $this
            ->setName($name)
            ->setClientLabel($clientLabel)
            ->setSafSecurityProfile($safSecurityProfile)
            ->setIpAddress($ipAddress)
            ->setDescription($description)
            ->setPort($port)
            ->setEnableTcpKeepAlive($enableTcpKeepAlive)
            ->setSafReconnectInterval($safReconnectInterval)
            ->setSafNotificationsWindowSize($safNotificationsWindowSize)
            ->setAssociatedCucms($associatedCucms);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XSafForwarder
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get clientLabel value
     * @return string
     */
    public function getClientLabel()
    {
        return $this->clientLabel;
    }
    /**
     * Set clientLabel value
     * @param string $clientLabel
     * @return XSafForwarder
     */
    public function setClientLabel($clientLabel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clientLabel) && strlen($clientLabel) > 255) || (is_array($clientLabel) && count($clientLabel) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clientLabel) ? strlen($clientLabel) : count($clientLabel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clientLabel) && !is_string($clientLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientLabel)), __LINE__);
        }
        $this->clientLabel = $clientLabel;
        return $this;
    }
    /**
     * Get safSecurityProfile value
     * @return XFkType
     */
    public function getSafSecurityProfile()
    {
        return $this->safSecurityProfile;
    }
    /**
     * Set safSecurityProfile value
     * @param XFkType $safSecurityProfile
     * @return XSafForwarder
     */
    public function setSafSecurityProfile(XFkType $safSecurityProfile = null)
    {
        $this->safSecurityProfile = $safSecurityProfile;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return XSafForwarder
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipAddress) && strlen($ipAddress) > 255) || (is_array($ipAddress) && count($ipAddress) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($ipAddress) ? strlen($ipAddress) : count($ipAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XSafForwarder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return XSafForwarder
     */
    public function setPort($port = '5050')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get enableTcpKeepAlive value
     * @return string|null
     */
    public function getEnableTcpKeepAlive()
    {
        return $this->enableTcpKeepAlive;
    }
    /**
     * Set enableTcpKeepAlive value
     * @param string $enableTcpKeepAlive
     * @return XSafForwarder
     */
    public function setEnableTcpKeepAlive($enableTcpKeepAlive = true)
    {
        // validation for constraint: pattern
        if (is_scalar($enableTcpKeepAlive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableTcpKeepAlive, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableTcpKeepAlive) && !is_string($enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableTcpKeepAlive)), __LINE__);
        }
        $this->enableTcpKeepAlive = $enableTcpKeepAlive;
        return $this;
    }
    /**
     * Get safReconnectInterval value
     * @return string|null
     */
    public function getSafReconnectInterval()
    {
        return $this->safReconnectInterval;
    }
    /**
     * Set safReconnectInterval value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safReconnectInterval
     * @return XSafForwarder
     */
    public function setSafReconnectInterval($safReconnectInterval = '20')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($safReconnectInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $safReconnectInterval, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->safReconnectInterval = $safReconnectInterval;
        return $this;
    }
    /**
     * Get safNotificationsWindowSize value
     * @return string|null
     */
    public function getSafNotificationsWindowSize()
    {
        return $this->safNotificationsWindowSize;
    }
    /**
     * Set safNotificationsWindowSize value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safNotificationsWindowSize
     * @return XSafForwarder
     */
    public function setSafNotificationsWindowSize($safNotificationsWindowSize = '7')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($safNotificationsWindowSize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $safNotificationsWindowSize, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->safNotificationsWindowSize = $safNotificationsWindowSize;
        return $this;
    }
    /**
     * Get associatedCucms value
     * @return AssociatedCucms|null
     */
    public function getAssociatedCucms()
    {
        return $this->associatedCucms;
    }
    /**
     * Set associatedCucms value
     * @param AssociatedCucms $associatedCucms
     * @return XSafForwarder
     */
    public function setAssociatedCucms(AssociatedCucms $associatedCucms = null)
    {
        $this->associatedCucms = $associatedCucms;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XSafForwarder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
