<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRouteFilterMember StructType
 * @subpackage Structs
 */
class XRouteFilterMember extends AbstractStructBase
{
    /**
     * The dialPlanTagName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $dialPlanTagName;
    /**
     * The operator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $operator;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $priority;
    /**
     * The digits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $digits;
    /**
     * Constructor method for XRouteFilterMember
     * @uses XRouteFilterMember::setDialPlanTagName()
     * @uses XRouteFilterMember::setOperator()
     * @uses XRouteFilterMember::setPriority()
     * @uses XRouteFilterMember::setDigits()
     * @param XFkType $dialPlanTagName
     * @param string $operator
     * @param string $priority
     * @param string $digits
     */
    public function __construct(XFkType $dialPlanTagName = null, $operator = null, $priority = null, $digits = null)
    {
        $this
            ->setDialPlanTagName($dialPlanTagName)
            ->setOperator($operator)
            ->setPriority($priority)
            ->setDigits($digits);
    }
    /**
     * Get dialPlanTagName value
     * @return XFkType
     */
    public function getDialPlanTagName()
    {
        return $this->dialPlanTagName;
    }
    /**
     * Set dialPlanTagName value
     * @param XFkType $dialPlanTagName
     * @return XRouteFilterMember
     */
    public function setDialPlanTagName(XFkType $dialPlanTagName = null)
    {
        $this->dialPlanTagName = $dialPlanTagName;
        return $this;
    }
    /**
     * Get operator value
     * @return string
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses XOperator::valueIsValid()
     * @uses XOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return XRouteFilterMember
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!XOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operator, implode(', ', XOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return XRouteFilterMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get digits value
     * @return string|null
     */
    public function getDigits()
    {
        return $this->digits;
    }
    /**
     * Set digits value
     * @param string $digits
     * @return XRouteFilterMember
     */
    public function setDigits($digits = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($digits) && strlen($digits) > 50) || (is_array($digits) && count($digits) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($digits) ? strlen($digits) : count($digits)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($digits) && !is_string($digits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digits)), __LINE__);
        }
        $this->digits = $digits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XRouteFilterMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
