<?php
/**
 * This class stands for XRSVPOverSIP EnumType
 * @subpackage Enumerations
 */
class XRSVPOverSIP
{
    /**
     * Constant for value 'Local RSVP'
     * @return string 'Local RSVP'
     */
    const VALUE_LOCAL_RSVP = 'Local RSVP';
    /**
     * Constant for value 'E2E'
     * @return string 'E2E'
     */
    const VALUE_E_2_E = 'E2E';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOCAL_RSVP
     * @uses self::VALUE_E_2_E
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOCAL_RSVP,
            self::VALUE_E_2_E,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
