<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPhoneLine StructType
 * @subpackage Structs
 */
class XPhoneLine extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $index;
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XDirn
     */
    public $dirn;
    /**
     * The recordingMediaSource
     * Meta informations extracted from the WSDL
     * - default: Gateway Preferred
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $recordingMediaSource;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $label;
    /**
     * The display
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $display;
    /**
     * The ringSetting
     * Meta informations extracted from the WSDL
     * - default: Ring
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSetting;
    /**
     * The consecutiveRingSetting
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - documentation: Consecutive Rings Setting. Replaces the consective ring setting on IPPhone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $consecutiveRingSetting;
    /**
     * The ringSettingIdlePickupAlert
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ringSettingIdlePickupAlert;
    /**
     * The ringSettingActivePickupAlert
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ringSettingActivePickupAlert;
    /**
     * The displayAscii
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $displayAscii;
    /**
     * The e164Mask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $e164Mask;
    /**
     * The mwlPolicy
     * Meta informations extracted from the WSDL
     * - default: Use System Policy
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mwlPolicy;
    /**
     * The maxNumCalls
     * Meta informations extracted from the WSDL
     * - default: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxNumCalls;
    /**
     * The busyTrigger
     * Meta informations extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The callInfoDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CallInfoDisplay
     */
    public $callInfoDisplay;
    /**
     * The recordingProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta informations extracted from the WSDL
     * - default: Call Recording Disabled
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMwi;
    /**
     * The speedDial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $speedDial;
    /**
     * The partitionUsage
     * Meta informations extracted from the WSDL
     * - default: General
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The associatedEndusers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AssociatedEndusers
     */
    public $associatedEndusers;
    /**
     * The missedCallLogging
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $missedCallLogging;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XPhoneLine
     * @uses XPhoneLine::setIndex()
     * @uses XPhoneLine::setDirn()
     * @uses XPhoneLine::setRecordingMediaSource()
     * @uses XPhoneLine::setLabel()
     * @uses XPhoneLine::setDisplay()
     * @uses XPhoneLine::setRingSetting()
     * @uses XPhoneLine::setConsecutiveRingSetting()
     * @uses XPhoneLine::setRingSettingIdlePickupAlert()
     * @uses XPhoneLine::setRingSettingActivePickupAlert()
     * @uses XPhoneLine::setDisplayAscii()
     * @uses XPhoneLine::setE164Mask()
     * @uses XPhoneLine::setMwlPolicy()
     * @uses XPhoneLine::setMaxNumCalls()
     * @uses XPhoneLine::setBusyTrigger()
     * @uses XPhoneLine::setCallInfoDisplay()
     * @uses XPhoneLine::setRecordingProfileName()
     * @uses XPhoneLine::setMonitoringCssName()
     * @uses XPhoneLine::setRecordingFlag()
     * @uses XPhoneLine::setAudibleMwi()
     * @uses XPhoneLine::setSpeedDial()
     * @uses XPhoneLine::setPartitionUsage()
     * @uses XPhoneLine::setAssociatedEndusers()
     * @uses XPhoneLine::setMissedCallLogging()
     * @uses XPhoneLine::setCtiid()
     * @param string $index
     * @param XDirn $dirn
     * @param string $recordingMediaSource
     * @param string $label
     * @param string $display
     * @param string $ringSetting
     * @param string $consecutiveRingSetting
     * @param string $ringSettingIdlePickupAlert
     * @param string $ringSettingActivePickupAlert
     * @param string $displayAscii
     * @param string $e164Mask
     * @param string $mwlPolicy
     * @param string $maxNumCalls
     * @param string $busyTrigger
     * @param CallInfoDisplay $callInfoDisplay
     * @param XFkType $recordingProfileName
     * @param XFkType $monitoringCssName
     * @param string $recordingFlag
     * @param string $audibleMwi
     * @param string $speedDial
     * @param string $partitionUsage
     * @param AssociatedEndusers $associatedEndusers
     * @param string $missedCallLogging
     * @param int $ctiid
     */
    public function __construct($index = null, XDirn $dirn = null, $recordingMediaSource = 'Gateway Preferred', $label = null, $display = null, $ringSetting = 'Ring', $consecutiveRingSetting = 'Use System Default', $ringSettingIdlePickupAlert = 'Use System Default', $ringSettingActivePickupAlert = 'Use System Default', $displayAscii = null, $e164Mask = null, $mwlPolicy = 'Use System Policy', $maxNumCalls = '2', $busyTrigger = '1', CallInfoDisplay $callInfoDisplay = null, XFkType $recordingProfileName = null, XFkType $monitoringCssName = null, $recordingFlag = 'Call Recording Disabled', $audibleMwi = 'Default', $speedDial = null, $partitionUsage = 'General', AssociatedEndusers $associatedEndusers = null, $missedCallLogging = true, $ctiid = null)
    {
        $this
            ->setIndex($index)
            ->setDirn($dirn)
            ->setRecordingMediaSource($recordingMediaSource)
            ->setLabel($label)
            ->setDisplay($display)
            ->setRingSetting($ringSetting)
            ->setConsecutiveRingSetting($consecutiveRingSetting)
            ->setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert)
            ->setRingSettingActivePickupAlert($ringSettingActivePickupAlert)
            ->setDisplayAscii($displayAscii)
            ->setE164Mask($e164Mask)
            ->setMwlPolicy($mwlPolicy)
            ->setMaxNumCalls($maxNumCalls)
            ->setBusyTrigger($busyTrigger)
            ->setCallInfoDisplay($callInfoDisplay)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setSpeedDial($speedDial)
            ->setPartitionUsage($partitionUsage)
            ->setAssociatedEndusers($associatedEndusers)
            ->setMissedCallLogging($missedCallLogging)
            ->setCtiid($ctiid);
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return XPhoneLine
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get dirn value
     * @return XDirn
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param XDirn $dirn
     * @return XPhoneLine
     */
    public function setDirn(XDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get recordingMediaSource value
     * @return string
     */
    public function getRecordingMediaSource()
    {
        return $this->recordingMediaSource;
    }
    /**
     * Set recordingMediaSource value
     * @uses XPreferredMediaSource::valueIsValid()
     * @uses XPreferredMediaSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingMediaSource
     * @return XPhoneLine
     */
    public function setRecordingMediaSource($recordingMediaSource = 'Gateway Preferred')
    {
        // validation for constraint: enumeration
        if (!XPreferredMediaSource::valueIsValid($recordingMediaSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recordingMediaSource, implode(', ', XPreferredMediaSource::getValidValues())), __LINE__);
        }
        $this->recordingMediaSource = $recordingMediaSource;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return XPhoneLine
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 50) || (is_array($label) && count($label) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->display;
    }
    /**
     * Set display value
     * @param string $display
     * @return XPhoneLine
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($display) && strlen($display) > 50) || (is_array($display) && count($display) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($display) ? strlen($display) : count($display)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($display)), __LINE__);
        }
        $this->display = $display;
        return $this;
    }
    /**
     * Get ringSetting value
     * @return string|null
     */
    public function getRingSetting()
    {
        return $this->ringSetting;
    }
    /**
     * Set ringSetting value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSetting
     * @return XPhoneLine
     */
    public function setRingSetting($ringSetting = 'Ring')
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($ringSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSetting, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSetting = $ringSetting;
        return $this;
    }
    /**
     * Get consecutiveRingSetting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConsecutiveRingSetting()
    {
        return isset($this->consecutiveRingSetting) ? $this->consecutiveRingSetting : null;
    }
    /**
     * Set consecutiveRingSetting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $consecutiveRingSetting
     * @return XPhoneLine
     */
    public function setConsecutiveRingSetting($consecutiveRingSetting = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($consecutiveRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $consecutiveRingSetting, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($consecutiveRingSetting) || (is_array($consecutiveRingSetting) && empty($consecutiveRingSetting))) {
            unset($this->consecutiveRingSetting);
        } else {
            $this->consecutiveRingSetting = $consecutiveRingSetting;
        }
        return $this;
    }
    /**
     * Get ringSettingIdlePickupAlert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRingSettingIdlePickupAlert()
    {
        return isset($this->ringSettingIdlePickupAlert) ? $this->ringSettingIdlePickupAlert : null;
    }
    /**
     * Set ringSettingIdlePickupAlert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingIdlePickupAlert
     * @return XPhoneLine
     */
    public function setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($ringSettingIdlePickupAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingIdlePickupAlert, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($ringSettingIdlePickupAlert) || (is_array($ringSettingIdlePickupAlert) && empty($ringSettingIdlePickupAlert))) {
            unset($this->ringSettingIdlePickupAlert);
        } else {
            $this->ringSettingIdlePickupAlert = $ringSettingIdlePickupAlert;
        }
        return $this;
    }
    /**
     * Get ringSettingActivePickupAlert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRingSettingActivePickupAlert()
    {
        return isset($this->ringSettingActivePickupAlert) ? $this->ringSettingActivePickupAlert : null;
    }
    /**
     * Set ringSettingActivePickupAlert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingActivePickupAlert
     * @return XPhoneLine
     */
    public function setRingSettingActivePickupAlert($ringSettingActivePickupAlert = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($ringSettingActivePickupAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingActivePickupAlert, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($ringSettingActivePickupAlert) || (is_array($ringSettingActivePickupAlert) && empty($ringSettingActivePickupAlert))) {
            unset($this->ringSettingActivePickupAlert);
        } else {
            $this->ringSettingActivePickupAlert = $ringSettingActivePickupAlert;
        }
        return $this;
    }
    /**
     * Get displayAscii value
     * @return string|null
     */
    public function getDisplayAscii()
    {
        return $this->displayAscii;
    }
    /**
     * Set displayAscii value
     * @param string $displayAscii
     * @return XPhoneLine
     */
    public function setDisplayAscii($displayAscii = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($displayAscii) && strlen($displayAscii) > 50) || (is_array($displayAscii) && count($displayAscii) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($displayAscii) ? strlen($displayAscii) : count($displayAscii)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($displayAscii) && !is_string($displayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayAscii)), __LINE__);
        }
        $this->displayAscii = $displayAscii;
        return $this;
    }
    /**
     * Get e164Mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getE164Mask()
    {
        return isset($this->e164Mask) ? $this->e164Mask : null;
    }
    /**
     * Set e164Mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $e164Mask
     * @return XPhoneLine
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($e164Mask) && strlen($e164Mask) > 255) || (is_array($e164Mask) && count($e164Mask) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($e164Mask) ? strlen($e164Mask) : count($e164Mask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164Mask)), __LINE__);
        }
        if (is_null($e164Mask) || (is_array($e164Mask) && empty($e164Mask))) {
            unset($this->e164Mask);
        } else {
            $this->e164Mask = $e164Mask;
        }
        return $this;
    }
    /**
     * Get mwlPolicy value
     * @return string|null
     */
    public function getMwlPolicy()
    {
        return $this->mwlPolicy;
    }
    /**
     * Set mwlPolicy value
     * @uses XMWLPolicy::valueIsValid()
     * @uses XMWLPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mwlPolicy
     * @return XPhoneLine
     */
    public function setMwlPolicy($mwlPolicy = 'Use System Policy')
    {
        // validation for constraint: enumeration
        if (!XMWLPolicy::valueIsValid($mwlPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mwlPolicy, implode(', ', XMWLPolicy::getValidValues())), __LINE__);
        }
        $this->mwlPolicy = $mwlPolicy;
        return $this;
    }
    /**
     * Get maxNumCalls value
     * @return string|null
     */
    public function getMaxNumCalls()
    {
        return $this->maxNumCalls;
    }
    /**
     * Set maxNumCalls value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumCalls
     * @return XPhoneLine
     */
    public function setMaxNumCalls($maxNumCalls = '2')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxNumCalls)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxNumCalls, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxNumCalls = $maxNumCalls;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return XPhoneLine
     */
    public function setBusyTrigger($busyTrigger = '1')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busyTrigger, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get callInfoDisplay value
     * @return CallInfoDisplay|null
     */
    public function getCallInfoDisplay()
    {
        return $this->callInfoDisplay;
    }
    /**
     * Set callInfoDisplay value
     * @param CallInfoDisplay $callInfoDisplay
     * @return XPhoneLine
     */
    public function setCallInfoDisplay(CallInfoDisplay $callInfoDisplay = null)
    {
        $this->callInfoDisplay = $callInfoDisplay;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRecordingProfileName()
    {
        return isset($this->recordingProfileName) ? $this->recordingProfileName : null;
    }
    /**
     * Set recordingProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $recordingProfileName
     * @return XPhoneLine
     */
    public function setRecordingProfileName(XFkType $recordingProfileName = null)
    {
        if (is_null($recordingProfileName) || (is_array($recordingProfileName) && empty($recordingProfileName))) {
            unset($this->recordingProfileName);
        } else {
            $this->recordingProfileName = $recordingProfileName;
        }
        return $this;
    }
    /**
     * Get monitoringCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMonitoringCssName()
    {
        return isset($this->monitoringCssName) ? $this->monitoringCssName : null;
    }
    /**
     * Set monitoringCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $monitoringCssName
     * @return XPhoneLine
     */
    public function setMonitoringCssName(XFkType $monitoringCssName = null)
    {
        if (is_null($monitoringCssName) || (is_array($monitoringCssName) && empty($monitoringCssName))) {
            unset($this->monitoringCssName);
        } else {
            $this->monitoringCssName = $monitoringCssName;
        }
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return string|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @uses XRecordingFlag::valueIsValid()
     * @uses XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingFlag
     * @return XPhoneLine
     */
    public function setRecordingFlag($recordingFlag = 'Call Recording Disabled')
    {
        // validation for constraint: enumeration
        if (!XRecordingFlag::valueIsValid($recordingFlag)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recordingFlag, implode(', ', XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return string|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMwi
     * @return XPhoneLine
     */
    public function setAudibleMwi($audibleMwi = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($audibleMwi)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $audibleMwi, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get speedDial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpeedDial()
    {
        return isset($this->speedDial) ? $this->speedDial : null;
    }
    /**
     * Set speedDial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $speedDial
     * @return XPhoneLine
     */
    public function setSpeedDial($speedDial = null)
    {
        // validation for constraint: string
        if (!is_null($speedDial) && !is_string($speedDial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($speedDial)), __LINE__);
        }
        if (is_null($speedDial) || (is_array($speedDial) && empty($speedDial))) {
            unset($this->speedDial);
        } else {
            $this->speedDial = $speedDial;
        }
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses XPartitionUsage::valueIsValid()
     * @uses XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return XPhoneLine
     */
    public function setPartitionUsage($partitionUsage = 'General')
    {
        // validation for constraint: enumeration
        if (!XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $partitionUsage, implode(', ', XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get associatedEndusers value
     * @return AssociatedEndusers|null
     */
    public function getAssociatedEndusers()
    {
        return $this->associatedEndusers;
    }
    /**
     * Set associatedEndusers value
     * @param AssociatedEndusers $associatedEndusers
     * @return XPhoneLine
     */
    public function setAssociatedEndusers(AssociatedEndusers $associatedEndusers = null)
    {
        $this->associatedEndusers = $associatedEndusers;
        return $this;
    }
    /**
     * Get missedCallLogging value
     * @return string|null
     */
    public function getMissedCallLogging()
    {
        return $this->missedCallLogging;
    }
    /**
     * Set missedCallLogging value
     * @param string $missedCallLogging
     * @return XPhoneLine
     */
    public function setMissedCallLogging($missedCallLogging = true)
    {
        // validation for constraint: pattern
        if (is_scalar($missedCallLogging) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $missedCallLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($missedCallLogging, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($missedCallLogging) && !is_string($missedCallLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($missedCallLogging)), __LINE__);
        }
        $this->missedCallLogging = $missedCallLogging;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return XPhoneLine
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XPhoneLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
