<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XParameterMember StructType
 * @subpackage Structs
 */
class XParameterMember extends AbstractStructBase
{
    /**
     * The selectionOrder
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $selectionOrder;
    /**
     * The parameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parameter;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * Constructor method for XParameterMember
     * @uses XParameterMember::setSelectionOrder()
     * @uses XParameterMember::setParameter()
     * @uses XParameterMember::setValue()
     * @param string $selectionOrder
     * @param string $parameter
     * @param string $value
     */
    public function __construct($selectionOrder = '0', $parameter = null, $value = null)
    {
        $this
            ->setSelectionOrder($selectionOrder)
            ->setParameter($parameter)
            ->setValue($value);
    }
    /**
     * Get selectionOrder value
     * @return string
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return XParameterMember
     */
    public function setSelectionOrder($selectionOrder = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionOrder, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Get parameter value
     * @return string|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @uses XDialParameter::valueIsValid()
     * @uses XDialParameter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parameter
     * @return XParameterMember
     */
    public function setParameter($parameter = null)
    {
        // validation for constraint: enumeration
        if (!XDialParameter::valueIsValid($parameter)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $parameter, implode(', ', XDialParameter::getValidValues())), __LINE__);
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return XParameterMember
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XParameterMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
