<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLineGroupMember StructType
 * @subpackage Structs
 */
class XLineGroupMember extends AbstractStructBase
{
    /**
     * The lineSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lineSelectionOrder;
    /**
     * The directoryNumber
     * Meta informations extracted from the WSDL
     * - documentation: The uuid attribute is read here
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XDirn
     */
    public $directoryNumber;
    /**
     * Constructor method for XLineGroupMember
     * @uses XLineGroupMember::setLineSelectionOrder()
     * @uses XLineGroupMember::setDirectoryNumber()
     * @param string $lineSelectionOrder
     * @param XDirn $directoryNumber
     */
    public function __construct($lineSelectionOrder = null, XDirn $directoryNumber = null)
    {
        $this
            ->setLineSelectionOrder($lineSelectionOrder)
            ->setDirectoryNumber($directoryNumber);
    }
    /**
     * Get lineSelectionOrder value
     * @return string
     */
    public function getLineSelectionOrder()
    {
        return $this->lineSelectionOrder;
    }
    /**
     * Set lineSelectionOrder value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineSelectionOrder
     * @return XLineGroupMember
     */
    public function setLineSelectionOrder($lineSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($lineSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lineSelectionOrder, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->lineSelectionOrder = $lineSelectionOrder;
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return XDirn
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param XDirn $directoryNumber
     * @return XLineGroupMember
     */
    public function setDirectoryNumber(XDirn $directoryNumber = null)
    {
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XLineGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
