<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeExclusionNumber StructType
 * @subpackage Structs
 */
class XImeExclusionNumber extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $pattern;
    /**
     * The imeExclusionNumberGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $imeExclusionNumberGroupName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * Constructor method for XImeExclusionNumber
     * @uses XImeExclusionNumber::setPattern()
     * @uses XImeExclusionNumber::setImeExclusionNumberGroupName()
     * @uses XImeExclusionNumber::setDescription()
     * @param string $pattern
     * @param XFkType $imeExclusionNumberGroupName
     * @param string $description
     */
    public function __construct($pattern = null, XFkType $imeExclusionNumberGroupName = null, $description = null)
    {
        $this
            ->setPattern($pattern)
            ->setImeExclusionNumberGroupName($imeExclusionNumberGroupName)
            ->setDescription($description);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return XImeExclusionNumber
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pattern) && strlen($pattern) > 16) || (is_array($pattern) && count($pattern) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($pattern) ? strlen($pattern) : count($pattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get imeExclusionNumberGroupName value
     * @return XFkType
     */
    public function getImeExclusionNumberGroupName()
    {
        return $this->imeExclusionNumberGroupName;
    }
    /**
     * Set imeExclusionNumberGroupName value
     * @param XFkType $imeExclusionNumberGroupName
     * @return XImeExclusionNumber
     */
    public function setImeExclusionNumberGroupName(XFkType $imeExclusionNumberGroupName = null)
    {
        $this->imeExclusionNumberGroupName = $imeExclusionNumberGroupName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XImeExclusionNumber
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XImeExclusionNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
