<?php
/**
 * This class stands for XHotspotAuthenticationMethod EnumType
 * @subpackage Enumerations
 */
class XHotspotAuthenticationMethod
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'WEP'
     * @return string 'WEP'
     */
    const VALUE_WEP = 'WEP';
    /**
     * Constant for value 'WPA-PSK'
     * @return string 'WPA-PSK'
     */
    const VALUE_WPA_PSK = 'WPA-PSK';
    /**
     * Constant for value 'WPA2-PSK'
     * @return string 'WPA2-PSK'
     */
    const VALUE_WPA_2_PSK = 'WPA2-PSK';
    /**
     * Constant for value 'EAP-FAST'
     * @return string 'EAP-FAST'
     */
    const VALUE_EAP_FAST = 'EAP-FAST';
    /**
     * Constant for value 'PEAP-MSCHAPv2'
     * @return string 'PEAP-MSCHAPv2'
     */
    const VALUE_PEAP_MSCHAPV_2 = 'PEAP-MSCHAPv2';
    /**
     * Constant for value 'PEAP-GTC'
     * @return string 'PEAP-GTC'
     */
    const VALUE_PEAP_GTC = 'PEAP-GTC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_WEP
     * @uses self::VALUE_WPA_PSK
     * @uses self::VALUE_WPA_2_PSK
     * @uses self::VALUE_EAP_FAST
     * @uses self::VALUE_PEAP_MSCHAPV_2
     * @uses self::VALUE_PEAP_GTC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_WEP,
            self::VALUE_WPA_PSK,
            self::VALUE_WPA_2_PSK,
            self::VALUE_EAP_FAST,
            self::VALUE_PEAP_MSCHAPV_2,
            self::VALUE_PEAP_GTC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
