<?php
/**
 * This class stands for XHostedRoutePatternPSTNRule EnumType
 * @subpackage Enumerations
 */
class XHostedRoutePatternPSTNRule
{
    /**
     * Constant for value 'Use pattern'
     * @return string 'Use pattern'
     */
    const VALUE_USE_PATTERN = 'Use pattern';
    /**
     * Constant for value 'Specify'
     * @return string 'Specify'
     */
    const VALUE_SPECIFY = 'Specify';
    /**
     * Constant for value 'No PSTN'
     * @return string 'No PSTN'
     */
    const VALUE_NO_PSTN = 'No PSTN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USE_PATTERN
     * @uses self::VALUE_SPECIFY
     * @uses self::VALUE_NO_PSTN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USE_PATTERN,
            self::VALUE_SPECIFY,
            self::VALUE_NO_PSTN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
