<?php
/**
 * This class stands for XGlobalNumber EnumType
 * @subpackage Enumerations
 */
class XGlobalNumber
{
    /**
     * Constant for value 'Enterprise Number'
     * @return string 'Enterprise Number'
     */
    const VALUE_ENTERPRISE_NUMBER = 'Enterprise Number';
    /**
     * Constant for value '+E.164 Number'
     * @return string '+E.164 Number'
     */
    const VALUE_E_164_NUMBER = '+E.164 Number';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENTERPRISE_NUMBER
     * @uses self::VALUE_E_164_NUMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENTERPRISE_NUMBER,
            self::VALUE_E_164_NUMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
