<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XGatewaySccp StructType
 * @subpackage Structs
 */
class XGatewaySccp extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $index;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - default: User
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $protocolSide;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $locationName;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $phoneTemplateName;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $securityProfileName;
    /**
     * The deviceMobilityMode
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $deviceMobilityMode;
    /**
     * The commonPhoneConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $commonPhoneConfigName;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVM
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $alwaysUsePrimeLineForVM;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for SCCP
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for SCCP
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $presenceGroupName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationFilterName;
    /**
     * The transmitUtf8
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The callingPartyNumberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $callingPartyNumberPrefix;
    /**
     * The callingPartyStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyStripDigits;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCssUnknown
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnknown;
    /**
     * The hotlineDevice
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: This tag is applicable for MGCP FXS ports,which supports PLAR.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $imeE164TransformationName;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The ownerUserId
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for SCCP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $ownerUserId;
    /**
     * The allowCtiControlFlag
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for SCCP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCtiControlFlag;
    /**
     * The remoteDevice
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for SCCP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for SCCP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - default: Off
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The hlogStatus
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for SCCP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hlogStatus;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for SCCP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Lines
     */
    public $lines;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XGatewaySccp
     * @uses XGatewaySccp::setIndex()
     * @uses XGatewaySccp::setName()
     * @uses XGatewaySccp::setProduct()
     * @uses XGatewaySccp::setClass()
     * @uses XGatewaySccp::setProtocol()
     * @uses XGatewaySccp::setProtocolSide()
     * @uses XGatewaySccp::setDevicePoolName()
     * @uses XGatewaySccp::setLocationName()
     * @uses XGatewaySccp::setPhoneTemplateName()
     * @uses XGatewaySccp::setSecurityProfileName()
     * @uses XGatewaySccp::setDeviceMobilityMode()
     * @uses XGatewaySccp::setCommonPhoneConfigName()
     * @uses XGatewaySccp::setAlwaysUsePrimeLine()
     * @uses XGatewaySccp::setAlwaysUsePrimeLineForVM()
     * @uses XGatewaySccp::setSubscribeCallingSearchSpaceName()
     * @uses XGatewaySccp::setPresenceGroupName()
     * @uses XGatewaySccp::setDescription()
     * @uses XGatewaySccp::setModel()
     * @uses XGatewaySccp::setCallingSearchSpaceName()
     * @uses XGatewaySccp::setCommonDeviceConfigName()
     * @uses XGatewaySccp::setNetworkLocale()
     * @uses XGatewaySccp::setMediaResourceListName()
     * @uses XGatewaySccp::setAutomatedAlternateRoutingCssName()
     * @uses XGatewaySccp::setAarNeighborhoodName()
     * @uses XGatewaySccp::setVendorConfig()
     * @uses XGatewaySccp::setMlppDomainId()
     * @uses XGatewaySccp::setUseTrustedRelayPoint()
     * @uses XGatewaySccp::setRetryVideoCallAsAudio()
     * @uses XGatewaySccp::setCgpnTransformationCssName()
     * @uses XGatewaySccp::setUseDevicePoolCgpnTransformCss()
     * @uses XGatewaySccp::setGeoLocationName()
     * @uses XGatewaySccp::setGeoLocationFilterName()
     * @uses XGatewaySccp::setTransmitUtf8()
     * @uses XGatewaySccp::setCdpnTransformationCssName()
     * @uses XGatewaySccp::setUseDevicePoolCdpnTransformCss()
     * @uses XGatewaySccp::setCallingPartyNumberPrefix()
     * @uses XGatewaySccp::setCallingPartyStripDigits()
     * @uses XGatewaySccp::setCallingPartyUnknownTransformationCssName()
     * @uses XGatewaySccp::setUseDevicePoolCgpnTransformCssUnknown()
     * @uses XGatewaySccp::setHotlineDevice()
     * @uses XGatewaySccp::setPacketCaptureMode()
     * @uses XGatewaySccp::setPacketCaptureDuration()
     * @uses XGatewaySccp::setPstnAccess()
     * @uses XGatewaySccp::setImeE164TransformationName()
     * @uses XGatewaySccp::setUserLocale()
     * @uses XGatewaySccp::setOwnerUserId()
     * @uses XGatewaySccp::setAllowCtiControlFlag()
     * @uses XGatewaySccp::setRemoteDevice()
     * @uses XGatewaySccp::setUnattendedPort()
     * @uses XGatewaySccp::setMlppIndicationStatus()
     * @uses XGatewaySccp::setPreemption()
     * @uses XGatewaySccp::setHlogStatus()
     * @uses XGatewaySccp::setIgnorePresentationIndicators()
     * @uses XGatewaySccp::setLines()
     * @uses XGatewaySccp::setConfidentialAccess()
     * @uses XGatewaySccp::setCtiid()
     * @param string $index
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param XFkType $devicePoolName
     * @param XFkType $locationName
     * @param XFkType $phoneTemplateName
     * @param XFkType $securityProfileName
     * @param string $deviceMobilityMode
     * @param XFkType $commonPhoneConfigName
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVM
     * @param XFkType $subscribeCallingSearchSpaceName
     * @param XFkType $presenceGroupName
     * @param string $description
     * @param string $model
     * @param XFkType $callingSearchSpaceName
     * @param XFkType $commonDeviceConfigName
     * @param string $networkLocale
     * @param XFkType $mediaResourceListName
     * @param XFkType $automatedAlternateRoutingCssName
     * @param XFkType $aarNeighborhoodName
     * @param XVendorConfig $vendorConfig
     * @param string $mlppDomainId
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param XFkType $geoLocationName
     * @param XFkType $geoLocationFilterName
     * @param string $transmitUtf8
     * @param XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $callingPartyNumberPrefix
     * @param string $callingPartyStripDigits
     * @param XFkType $callingPartyUnknownTransformationCssName
     * @param string $useDevicePoolCgpnTransformCssUnknown
     * @param string $hotlineDevice
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $pstnAccess
     * @param XFkType $imeE164TransformationName
     * @param string $userLocale
     * @param XFkType $ownerUserId
     * @param string $allowCtiControlFlag
     * @param string $remoteDevice
     * @param string $unattendedPort
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $hlogStatus
     * @param string $ignorePresentationIndicators
     * @param Lines $lines
     * @param ConfidentialAccess $confidentialAccess
     * @param int $ctiid
     */
    public function __construct($index = '0', $name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', XFkType $devicePoolName = null, XFkType $locationName = null, XFkType $phoneTemplateName = null, XFkType $securityProfileName = null, $deviceMobilityMode = 'Default', XFkType $commonPhoneConfigName = null, $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVM = 'Default', XFkType $subscribeCallingSearchSpaceName = null, XFkType $presenceGroupName = null, $description = null, $model = null, XFkType $callingSearchSpaceName = null, XFkType $commonDeviceConfigName = null, $networkLocale = null, XFkType $mediaResourceListName = null, XFkType $automatedAlternateRoutingCssName = null, XFkType $aarNeighborhoodName = null, XVendorConfig $vendorConfig = null, $mlppDomainId = null, $useTrustedRelayPoint = 'Default', $retryVideoCallAsAudio = true, XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = true, XFkType $geoLocationName = null, XFkType $geoLocationFilterName = null, $transmitUtf8 = false, XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = true, $callingPartyNumberPrefix = null, $callingPartyStripDigits = null, XFkType $callingPartyUnknownTransformationCssName = null, $useDevicePoolCgpnTransformCssUnknown = true, $hotlineDevice = false, $packetCaptureMode = 'None', $packetCaptureDuration = '0', $pstnAccess = true, XFkType $imeE164TransformationName = null, $userLocale = null, XFkType $ownerUserId = null, $allowCtiControlFlag = null, $remoteDevice = null, $unattendedPort = null, $mlppIndicationStatus = 'Off', $preemption = 'Default', $hlogStatus = null, $ignorePresentationIndicators = null, Lines $lines = null, ConfidentialAccess $confidentialAccess = null, $ctiid = null)
    {
        $this
            ->setIndex($index)
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setSecurityProfileName($securityProfileName)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVM($alwaysUsePrimeLineForVM)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setPresenceGroupName($presenceGroupName)
            ->setDescription($description)
            ->setModel($model)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocale($networkLocale)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setVendorConfig($vendorConfig)
            ->setMlppDomainId($mlppDomainId)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setTransmitUtf8($transmitUtf8)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setCallingPartyNumberPrefix($callingPartyNumberPrefix)
            ->setCallingPartyStripDigits($callingPartyStripDigits)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setUseDevicePoolCgpnTransformCssUnknown($useDevicePoolCgpnTransformCssUnknown)
            ->setHotlineDevice($hotlineDevice)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUserLocale($userLocale)
            ->setOwnerUserId($ownerUserId)
            ->setAllowCtiControlFlag($allowCtiControlFlag)
            ->setRemoteDevice($remoteDevice)
            ->setUnattendedPort($unattendedPort)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setHlogStatus($hlogStatus)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setLines($lines)
            ->setConfidentialAccess($confidentialAccess)
            ->setCtiid($ctiid);
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return XGatewaySccp
     */
    public function setIndex($index = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XGatewaySccp
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return XGatewaySccp
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses XClass::valueIsValid()
     * @uses XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return XGatewaySccp
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return XGatewaySccp
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses XProtocolSide::valueIsValid()
     * @uses XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return XGatewaySccp
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        // validation for constraint: enumeration
        if (!XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return XGatewaySccp
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return XGatewaySccp
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return XFkType
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param XFkType $phoneTemplateName
     * @return XGatewaySccp
     */
    public function setPhoneTemplateName(XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return XFkType
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param XFkType $securityProfileName
     * @return XGatewaySccp
     */
    public function setSecurityProfileName(XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return string
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceMobilityMode
     * @return XGatewaySccp
     */
    public function setDeviceMobilityMode($deviceMobilityMode = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($deviceMobilityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceMobilityMode, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return XFkType
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param XFkType $commonPhoneConfigName
     * @return XGatewaySccp
     */
    public function setCommonPhoneConfigName(XFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return XGatewaySccp
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVM value
     * @return string
     */
    public function getAlwaysUsePrimeLineForVM()
    {
        return $this->alwaysUsePrimeLineForVM;
    }
    /**
     * Set alwaysUsePrimeLineForVM value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVM
     * @return XGatewaySccp
     */
    public function setAlwaysUsePrimeLineForVM($alwaysUsePrimeLineForVM = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLineForVM)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVM, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVM = $alwaysUsePrimeLineForVM;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return XFkType
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param XFkType $subscribeCallingSearchSpaceName
     * @return XGatewaySccp
     */
    public function setSubscribeCallingSearchSpaceName(XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return XFkType
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param XFkType $presenceGroupName
     * @return XGatewaySccp
     */
    public function setPresenceGroupName(XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XGatewaySccp
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses XModel::valueIsValid()
     * @uses XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return XGatewaySccp
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingSearchSpaceName
     * @return XGatewaySccp
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $commonDeviceConfigName
     * @return XGatewaySccp
     */
    public function setCommonDeviceConfigName(XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XCountry::valueIsValid()
     * @uses XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return XGatewaySccp
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', XCountry::getValidValues())), __LINE__);
        }
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $mediaResourceListName
     * @return XGatewaySccp
     */
    public function setMediaResourceListName(XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $automatedAlternateRoutingCssName
     * @return XGatewaySccp
     */
    public function setAutomatedAlternateRoutingCssName(XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $aarNeighborhoodName
     * @return XGatewaySccp
     */
    public function setAarNeighborhoodName(XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param XVendorConfig $vendorConfig
     * @return XGatewaySccp
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return XGatewaySccp
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return XGatewaySccp
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return XGatewaySccp
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = true)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $cgpnTransformationCssName
     * @return XGatewaySccp
     */
    public function setCgpnTransformationCssName(XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return XGatewaySccp
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $geoLocationName
     * @return XGatewaySccp
     */
    public function setGeoLocationName(XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $geoLocationFilterName
     * @return XGatewaySccp
     */
    public function setGeoLocationFilterName(XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return XGatewaySccp
     */
    public function setTransmitUtf8($transmitUtf8 = false)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitUtf8)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $cdpnTransformationCssName
     * @return XGatewaySccp
     */
    public function setCdpnTransformationCssName(XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return XGatewaySccp
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get callingPartyNumberPrefix value
     * @return string|null
     */
    public function getCallingPartyNumberPrefix()
    {
        return $this->callingPartyNumberPrefix;
    }
    /**
     * Set callingPartyNumberPrefix value
     * @param string $callingPartyNumberPrefix
     * @return XGatewaySccp
     */
    public function setCallingPartyNumberPrefix($callingPartyNumberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyNumberPrefix) && strlen($callingPartyNumberPrefix) > 16) || (is_array($callingPartyNumberPrefix) && count($callingPartyNumberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyNumberPrefix) ? strlen($callingPartyNumberPrefix) : count($callingPartyNumberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyNumberPrefix) && !is_string($callingPartyNumberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyNumberPrefix)), __LINE__);
        }
        $this->callingPartyNumberPrefix = $callingPartyNumberPrefix;
        return $this;
    }
    /**
     * Get callingPartyStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyStripDigits()
    {
        return isset($this->callingPartyStripDigits) ? $this->callingPartyStripDigits : null;
    }
    /**
     * Set callingPartyStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyStripDigits
     * @return XGatewaySccp
     */
    public function setCallingPartyStripDigits($callingPartyStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($callingPartyStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyStripDigits) || (is_array($callingPartyStripDigits) && empty($callingPartyStripDigits))) {
            unset($this->callingPartyStripDigits);
        } else {
            $this->callingPartyStripDigits = $callingPartyStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return isset($this->callingPartyUnknownTransformationCssName) ? $this->callingPartyUnknownTransformationCssName : null;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingPartyUnknownTransformationCssName
     * @return XGatewaySccp
     */
    public function setCallingPartyUnknownTransformationCssName(XFkType $callingPartyUnknownTransformationCssName = null)
    {
        if (is_null($callingPartyUnknownTransformationCssName) || (is_array($callingPartyUnknownTransformationCssName) && empty($callingPartyUnknownTransformationCssName))) {
            unset($this->callingPartyUnknownTransformationCssName);
        } else {
            $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnknown value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnknown()
    {
        return $this->useDevicePoolCgpnTransformCssUnknown;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnknown value
     * @param string $useDevicePoolCgpnTransformCssUnknown
     * @return XGatewaySccp
     */
    public function setUseDevicePoolCgpnTransformCssUnknown($useDevicePoolCgpnTransformCssUnknown = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssUnknown) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnknown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssUnknown, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnknown) && !is_string($useDevicePoolCgpnTransformCssUnknown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssUnknown)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnknown = $useDevicePoolCgpnTransformCssUnknown;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return XGatewaySccp
     */
    public function setHotlineDevice($hotlineDevice = false)
    {
        // validation for constraint: pattern
        if (is_scalar($hotlineDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($hotlineDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hotlineDevice) && !is_string($hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotlineDevice)), __LINE__);
        }
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses XPacketCaptureMode::valueIsValid()
     * @uses XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return XGatewaySccp
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        // validation for constraint: enumeration
        if (!XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return XGatewaySccp
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return XGatewaySccp
     */
    public function setPstnAccess($pstnAccess = true)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $imeE164TransformationName
     * @return XGatewaySccp
     */
    public function setImeE164TransformationName(XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return XGatewaySccp
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get ownerUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getOwnerUserId()
    {
        return isset($this->ownerUserId) ? $this->ownerUserId : null;
    }
    /**
     * Set ownerUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $ownerUserId
     * @return XGatewaySccp
     */
    public function setOwnerUserId(XFkType $ownerUserId = null)
    {
        if (is_null($ownerUserId) || (is_array($ownerUserId) && empty($ownerUserId))) {
            unset($this->ownerUserId);
        } else {
            $this->ownerUserId = $ownerUserId;
        }
        return $this;
    }
    /**
     * Get allowCtiControlFlag value
     * @return string|null
     */
    public function getAllowCtiControlFlag()
    {
        return $this->allowCtiControlFlag;
    }
    /**
     * Set allowCtiControlFlag value
     * @param string $allowCtiControlFlag
     * @return XGatewaySccp
     */
    public function setAllowCtiControlFlag($allowCtiControlFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowCtiControlFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowCtiControlFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowCtiControlFlag) && !is_string($allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowCtiControlFlag)), __LINE__);
        }
        $this->allowCtiControlFlag = $allowCtiControlFlag;
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return XGatewaySccp
     */
    public function setRemoteDevice($remoteDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($remoteDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($remoteDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteDevice) && !is_string($remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteDevice)), __LINE__);
        }
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get unattendedPort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return isset($this->unattendedPort) ? $this->unattendedPort : null;
    }
    /**
     * Set unattendedPort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unattendedPort
     * @return XGatewaySccp
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        if (is_null($unattendedPort) || (is_array($unattendedPort) && empty($unattendedPort))) {
            unset($this->unattendedPort);
        } else {
            $this->unattendedPort = $unattendedPort;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return XGatewaySccp
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses XPreemption::valueIsValid()
     * @uses XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return XGatewaySccp
     */
    public function setPreemption($preemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get hlogStatus value
     * @return string|null
     */
    public function getHlogStatus()
    {
        return $this->hlogStatus;
    }
    /**
     * Set hlogStatus value
     * @param string $hlogStatus
     * @return XGatewaySccp
     */
    public function setHlogStatus($hlogStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hlogStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hlogStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($hlogStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hlogStatus) && !is_string($hlogStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hlogStatus)), __LINE__);
        }
        $this->hlogStatus = $hlogStatus;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ignorePresentationIndicators
     * @return XGatewaySccp
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ignorePresentationIndicators, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get lines value
     * @return Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param Lines $lines
     * @return XGatewaySccp
     */
    public function setLines(Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return XGatewaySccp
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return XGatewaySccp
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XGatewaySccp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
