<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XE164AltNum StructType
 * @subpackage Structs
 */
class XE164AltNum extends AbstractStructBase
{
    /**
     * The numberMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numberMask;
    /**
     * The addToLocalRoutePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $addToLocalRoutePartition;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $routePartition;
    /**
     * The isUrgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isUrgent;
    /**
     * The advertiseGloballyIls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $advertiseGloballyIls;
    /**
     * Constructor method for XE164AltNum
     * @uses XE164AltNum::setNumberMask()
     * @uses XE164AltNum::setAddToLocalRoutePartition()
     * @uses XE164AltNum::setRoutePartition()
     * @uses XE164AltNum::setIsUrgent()
     * @uses XE164AltNum::setAdvertiseGloballyIls()
     * @param string $numberMask
     * @param string $addToLocalRoutePartition
     * @param XFkType $routePartition
     * @param string $isUrgent
     * @param string $advertiseGloballyIls
     */
    public function __construct($numberMask = null, $addToLocalRoutePartition = null, XFkType $routePartition = null, $isUrgent = null, $advertiseGloballyIls = null)
    {
        $this
            ->setNumberMask($numberMask)
            ->setAddToLocalRoutePartition($addToLocalRoutePartition)
            ->setRoutePartition($routePartition)
            ->setIsUrgent($isUrgent)
            ->setAdvertiseGloballyIls($advertiseGloballyIls);
    }
    /**
     * Get numberMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberMask()
    {
        return isset($this->numberMask) ? $this->numberMask : null;
    }
    /**
     * Set numberMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberMask
     * @return XE164AltNum
     */
    public function setNumberMask($numberMask = null)
    {
        // validation for constraint: string
        if (!is_null($numberMask) && !is_string($numberMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberMask)), __LINE__);
        }
        if (is_null($numberMask) || (is_array($numberMask) && empty($numberMask))) {
            unset($this->numberMask);
        } else {
            $this->numberMask = $numberMask;
        }
        return $this;
    }
    /**
     * Get addToLocalRoutePartition value
     * @return string|null
     */
    public function getAddToLocalRoutePartition()
    {
        return $this->addToLocalRoutePartition;
    }
    /**
     * Set addToLocalRoutePartition value
     * @param string $addToLocalRoutePartition
     * @return XE164AltNum
     */
    public function setAddToLocalRoutePartition($addToLocalRoutePartition = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addToLocalRoutePartition) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $addToLocalRoutePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($addToLocalRoutePartition, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addToLocalRoutePartition) && !is_string($addToLocalRoutePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addToLocalRoutePartition)), __LINE__);
        }
        $this->addToLocalRoutePartition = $addToLocalRoutePartition;
        return $this;
    }
    /**
     * Get routePartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRoutePartition()
    {
        return isset($this->routePartition) ? $this->routePartition : null;
    }
    /**
     * Set routePartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $routePartition
     * @return XE164AltNum
     */
    public function setRoutePartition(XFkType $routePartition = null)
    {
        if (is_null($routePartition) || (is_array($routePartition) && empty($routePartition))) {
            unset($this->routePartition);
        } else {
            $this->routePartition = $routePartition;
        }
        return $this;
    }
    /**
     * Get isUrgent value
     * @return string|null
     */
    public function getIsUrgent()
    {
        return $this->isUrgent;
    }
    /**
     * Set isUrgent value
     * @param string $isUrgent
     * @return XE164AltNum
     */
    public function setIsUrgent($isUrgent = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isUrgent) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isUrgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isUrgent, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isUrgent) && !is_string($isUrgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isUrgent)), __LINE__);
        }
        $this->isUrgent = $isUrgent;
        return $this;
    }
    /**
     * Get advertiseGloballyIls value
     * @return string|null
     */
    public function getAdvertiseGloballyIls()
    {
        return $this->advertiseGloballyIls;
    }
    /**
     * Set advertiseGloballyIls value
     * @param string $advertiseGloballyIls
     * @return XE164AltNum
     */
    public function setAdvertiseGloballyIls($advertiseGloballyIls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($advertiseGloballyIls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $advertiseGloballyIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($advertiseGloballyIls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($advertiseGloballyIls) && !is_string($advertiseGloballyIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advertiseGloballyIls)), __LINE__);
        }
        $this->advertiseGloballyIls = $advertiseGloballyIls;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XE164AltNum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
