<?php
/**
 * This class stands for XDigitSending EnumType
 * @subpackage Enumerations
 */
class XDigitSending
{
    /**
     * Constant for value 'DTMF'
     * @return string 'DTMF'
     */
    const VALUE_DTMF = 'DTMF';
    /**
     * Constant for value 'MF'
     * @return string 'MF'
     */
    const VALUE_MF = 'MF';
    /**
     * Constant for value 'PULSE'
     * @return string 'PULSE'
     */
    const VALUE_PULSE = 'PULSE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DTMF
     * @uses self::VALUE_MF
     * @uses self::VALUE_PULSE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DTMF,
            self::VALUE_MF,
            self::VALUE_PULSE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
